/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.common;

import dev.openfeature.contrib.providers.flagd.FlagdOptions;
import dev.openfeature.contrib.providers.flagd.resolver.common.FlagdGrpcInterceptor;
import dev.openfeature.contrib.providers.flagd.resolver.common.GenericConfigException;
import dev.openfeature.contrib.providers.flagd.resolver.common.SslConfigException;
import dev.openfeature.contrib.providers.flagd.resolver.common.SupportedScheme;
import dev.openfeature.contrib.providers.flagd.resolver.common.nameresolvers.EnvoyResolverProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.NameResolverProvider;
import io.grpc.NameResolverRegistry;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;

public class ChannelBuilder {
    private ChannelBuilder() {
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="certificate path is a user input")
    public static ManagedChannel nettyChannel(FlagdOptions options) {
        long keepAliveMs;
        long l = keepAliveMs = options.getKeepAlive() == 0L ? Long.MAX_VALUE : options.getKeepAlive();
        if (options.getSocketPath() != null) {
            if (!Epoll.isAvailable()) {
                throw new IllegalStateException("unix socket cannot be used", Epoll.unavailabilityCause());
            }
            return NettyChannelBuilder.forAddress((SocketAddress)new DomainSocketAddress(options.getSocketPath())).keepAliveTime(keepAliveMs, TimeUnit.MILLISECONDS).eventLoopGroup((EventLoopGroup)new EpollEventLoopGroup()).channelType(EpollDomainSocketChannel.class).usePlaintext().build();
        }
        try {
            if (ChannelBuilder.isEnvoyTarget(options.getTargetUri())) {
                NameResolverRegistry.getDefaultRegistry().register((NameResolverProvider)new EnvoyResolverProvider());
            }
            String defaultTarget = String.format("%s:%s", options.getHost(), options.getPort());
            String targetUri = ChannelBuilder.isValidTargetUri(options.getTargetUri()) ? options.getTargetUri() : defaultTarget;
            NettyChannelBuilder builder = NettyChannelBuilder.forTarget((String)targetUri).keepAliveTime(keepAliveMs, TimeUnit.MILLISECONDS);
            if (options.isTls()) {
                File file;
                SslContextBuilder sslContext = GrpcSslContexts.forClient();
                if (options.getCertPath() != null && (file = new File(options.getCertPath())).exists()) {
                    sslContext.trustManager(file);
                }
                builder.sslContext(sslContext.build());
            } else {
                builder.usePlaintext();
            }
            if (options.getOpenTelemetry() != null) {
                builder.intercept(new ClientInterceptor[]{new FlagdGrpcInterceptor(options.getOpenTelemetry())});
            }
            return builder.build();
        }
        catch (SSLException ssle) {
            SslConfigException sslConfigException = new SslConfigException("Error with SSL configuration.");
            sslConfigException.initCause(ssle);
            throw sslConfigException;
        }
        catch (IllegalArgumentException argumentException) {
            GenericConfigException genericConfigException = new GenericConfigException("Error with gRPC target string configuration");
            genericConfigException.initCause(argumentException);
            throw genericConfigException;
        }
    }

    private static boolean isValidTargetUri(String targetUri) {
        if (targetUri == null) {
            return false;
        }
        try {
            String scheme = new URI(targetUri).getScheme();
            if (scheme.equals(SupportedScheme.ENVOY.getScheme()) || scheme.equals(SupportedScheme.DNS.getScheme()) || scheme.equals(SupportedScheme.XDS.getScheme()) || scheme.equals(SupportedScheme.UDS.getScheme())) {
                return true;
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid target string", e);
        }
        return false;
    }

    private static boolean isEnvoyTarget(String targetUri) {
        if (targetUri == null) {
            return false;
        }
        try {
            String scheme = new URI(targetUri).getScheme();
            if (scheme.equals(SupportedScheme.ENVOY.getScheme())) {
                return true;
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid target string", e);
        }
        return false;
    }
}

