/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.common.backoff;

import dev.openfeature.contrib.providers.flagd.resolver.common.backoff.BackoffStrategy;
import dev.openfeature.contrib.providers.flagd.resolver.common.backoff.ConstantTimeBackoff;
import dev.openfeature.contrib.providers.flagd.resolver.common.backoff.ExponentialTimeBackoff;
import dev.openfeature.contrib.providers.flagd.resolver.common.backoff.NumberOfRetriesBackoff;

public class BackoffStrategies {
    private BackoffStrategies() {
    }

    public static BackoffStrategy exponentialTimeBackoff(long initialBackoffMillis) {
        return new ExponentialTimeBackoff(initialBackoffMillis);
    }

    public static BackoffStrategy exponentialTimeBackoff(long initialBackoffMillis, long maxBackoffMillis) {
        return new ExponentialTimeBackoff(initialBackoffMillis, maxBackoffMillis);
    }

    public static BackoffStrategy constantTimeBackoff(long millis) {
        return new ConstantTimeBackoff(millis);
    }

    public static BackoffStrategy noBackoff() {
        return new ConstantTimeBackoff(0L);
    }

    public static BackoffStrategy maxRetriesWithExponentialTimeBackoffStrategy(int maxRetries, long initialBackoffMillis) {
        return new NumberOfRetriesBackoff(maxRetries, BackoffStrategies.exponentialTimeBackoff(initialBackoffMillis));
    }
}

