/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.common.backoff;

import dev.openfeature.contrib.providers.flagd.resolver.common.backoff.BackoffService;
import dev.openfeature.contrib.providers.flagd.resolver.common.backoff.BackoffStrategies;
import dev.openfeature.contrib.providers.flagd.resolver.common.backoff.BackoffStrategy;
import dev.openfeature.contrib.providers.flagd.resolver.common.backoff.CombinedBackoff;
import dev.openfeature.contrib.providers.flagd.resolver.common.backoff.NumberOfRetriesBackoff;

public class GrpcStreamConnectorBackoffService
extends BackoffService {
    private final BackoffStrategy silentRecoverBackoff;

    public GrpcStreamConnectorBackoffService(long initialBackoffMillis) {
        this(BackoffStrategies.exponentialTimeBackoff(initialBackoffMillis));
    }

    public GrpcStreamConnectorBackoffService(BackoffStrategy errorBackoff) {
        this((BackoffStrategy)new NumberOfRetriesBackoff(1, BackoffStrategies.noBackoff()), errorBackoff);
    }

    private GrpcStreamConnectorBackoffService(BackoffStrategy silentRecoverBackoff, BackoffStrategy errorBackoff) {
        super(new CombinedBackoff(new BackoffStrategy[]{silentRecoverBackoff, errorBackoff}));
        this.silentRecoverBackoff = silentRecoverBackoff;
    }

    public boolean shouldRetrySilently() {
        return ((CombinedBackoff)this.getStrategy()).getCurrentStrategy() == this.silentRecoverBackoff;
    }
}

