/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.common.backoff;

import dev.openfeature.contrib.providers.flagd.resolver.common.backoff.BackoffStrategy;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;

public class CombinedBackoff
implements BackoffStrategy {
    private final BackoffStrategy[] backoffStrategies;
    private int currentStrategyIndex;
    private BackoffStrategy currentStrategy;

    public CombinedBackoff(BackoffStrategy[] backoffStrategies) {
        this.backoffStrategies = (BackoffStrategy[])backoffStrategies.clone();
        this.currentStrategyIndex = 0;
        this.currentStrategy = this.backoffStrategies[this.currentStrategyIndex];
        this.updateCurrentStrategy();
    }

    @Override
    public long getCurrentBackoffMillis() {
        return this.currentStrategy.getCurrentBackoffMillis();
    }

    @Override
    public boolean isExhausted() {
        this.updateCurrentStrategy();
        return this.currentStrategy.isExhausted();
    }

    @Override
    public void nextBackoff() {
        this.updateCurrentStrategy();
        this.currentStrategy.nextBackoff();
    }

    private void updateCurrentStrategy() {
        while (!this.isLastStrategy() && this.currentStrategy.isExhausted()) {
            ++this.currentStrategyIndex;
            this.currentStrategy = this.backoffStrategies[this.currentStrategyIndex];
        }
    }

    private boolean isLastStrategy() {
        return this.currentStrategyIndex + 1 >= this.backoffStrategies.length;
    }

    @Override
    public void reset() {
        for (int i = 0; i <= this.currentStrategyIndex; ++i) {
            this.backoffStrategies[i].reset();
        }
        this.currentStrategyIndex = 0;
        this.currentStrategy = this.backoffStrategies[this.currentStrategyIndex];
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BackoffStrategy getCurrentStrategy() {
        return this.currentStrategy;
    }
}

