/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.common.backoff;

import dev.openfeature.contrib.providers.flagd.resolver.common.backoff.BackoffStrategy;

public class ExponentialTimeBackoff
implements BackoffStrategy {
    public static final long DEFAULT_MAX_BACK_OFF = 120000L;
    private final long initialBackoff;
    private final long maxBackoff;
    private long currentBackoff;

    public ExponentialTimeBackoff(long initialBackoffMillis) {
        this(initialBackoffMillis, 120000L);
    }

    public ExponentialTimeBackoff(long initialBackoffMillis, long maxBackoffMillis) {
        this.initialBackoff = initialBackoffMillis;
        this.maxBackoff = maxBackoffMillis;
        this.reset();
    }

    @Override
    public long getCurrentBackoffMillis() {
        return this.currentBackoff;
    }

    @Override
    public boolean isExhausted() {
        return false;
    }

    @Override
    public void nextBackoff() {
        this.currentBackoff = Math.min(this.currentBackoff * 2L, this.maxBackoff);
    }

    @Override
    public void reset() {
        this.currentBackoff = Math.min(this.initialBackoff, this.maxBackoff);
    }
}

