/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.common.backoff;

import dev.openfeature.contrib.providers.flagd.resolver.common.backoff.BackoffStrategy;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;

public class NumberOfRetriesBackoff
implements BackoffStrategy {
    private final int numRetries;
    private final BackoffStrategy backoffStrategy;
    private int retryCount;

    public NumberOfRetriesBackoff(int numRetries, BackoffStrategy backoffStrategy) {
        this.numRetries = numRetries;
        this.backoffStrategy = backoffStrategy;
        this.retryCount = 0;
    }

    @Override
    public long getCurrentBackoffMillis() {
        return this.backoffStrategy.getCurrentBackoffMillis();
    }

    @Override
    public boolean isExhausted() {
        return this.retryCount >= this.numRetries;
    }

    @Override
    public void nextBackoff() {
        if (this.isExhausted()) {
            return;
        }
        ++this.retryCount;
        this.backoffStrategy.nextBackoff();
    }

    @Override
    public void reset() {
        this.retryCount = 0;
        this.backoffStrategy.reset();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getRetryCount() {
        return this.retryCount;
    }
}

