/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.common.nameresolvers;

import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.Status;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;

public class EnvoyResolver
extends NameResolver {
    private final URI uri;
    private final String authority;
    private NameResolver.Listener2 listener;

    public EnvoyResolver(URI targetUri) {
        this.uri = targetUri;
        this.authority = targetUri.getPath().substring(1);
    }

    public String getServiceAuthority() {
        return this.authority;
    }

    public void shutdown() {
    }

    public void start(NameResolver.Listener2 listener) {
        this.listener = listener;
        this.resolve();
    }

    public void refresh() {
        this.resolve();
    }

    private void resolve() {
        try {
            InetSocketAddress address = new InetSocketAddress(this.uri.getHost(), this.uri.getPort());
            Attributes addressGroupAttributes = Attributes.newBuilder().set(EquivalentAddressGroup.ATTR_AUTHORITY_OVERRIDE, (Object)this.authority).build();
            List<EquivalentAddressGroup> equivalentAddressGroup = Collections.singletonList(new EquivalentAddressGroup((SocketAddress)address, addressGroupAttributes));
            NameResolver.ResolutionResult resolutionResult = NameResolver.ResolutionResult.newBuilder().setAddresses(equivalentAddressGroup).build();
            this.listener.onResult(resolutionResult);
        }
        catch (Exception e) {
            this.listener.onError(Status.UNAVAILABLE.withDescription("Unable to resolve host ").withCause((Throwable)e));
        }
    }
}

