/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.grpc.strategy;

import com.google.protobuf.Message;
import dev.openfeature.contrib.providers.flagd.resolver.grpc.strategy.ResolveStrategy;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class TracedResolving
implements ResolveStrategy {
    private final Tracer tracer;

    public TracedResolving(@Nonnull OpenTelemetry telemetry) {
        this.tracer = telemetry.getTracer("OpenFeature/dev.openfeature.contrib.providers.flagd");
    }

    /*
     * Loose catch block
     */
    @Override
    public <ReqT extends Message, ResT extends Message> ResT resolve(Function<ReqT, ResT> resolverRef, Message req, String key) {
        Span span = this.tracer.spanBuilder("resolve").setSpanKind(SpanKind.CLIENT).startSpan();
        span.setAttribute("feature_flag.key", key);
        span.setAttribute("feature_flag.provider_name", "flagd");
        try {
            Message message;
            try (Scope scope = span.makeCurrent();){
                message = (Message)resolverRef.apply(req);
            }
            return (ResT)message;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            span.end();
        }
    }
}

