/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.common.backoff;

import dev.openfeature.contrib.providers.flagd.resolver.common.backoff.BackoffStrategy;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;

public class BackoffService {
    public static final int DEFAULT_MAX_JITTER = 256;
    private final BackoffStrategy strategy;
    private final int maxJitter;

    public BackoffService(BackoffStrategy strategy) {
        this(strategy, 256);
    }

    public BackoffService(BackoffStrategy strategy, int maxJitter) {
        this.strategy = strategy;
        this.maxJitter = maxJitter;
    }

    public long getCurrentBackoffMillis() {
        return this.strategy.getCurrentBackoffMillis();
    }

    public long getRandomJitter() {
        if (this.maxJitter == 0) {
            return 0L;
        }
        return ThreadLocalRandom.current().nextInt(this.maxJitter);
    }

    public void reset() {
        this.strategy.reset();
    }

    public boolean shouldRetry() {
        return !this.strategy.isExhausted();
    }

    public void waitUntilNextAttempt() throws InterruptedException {
        long retryDelay = this.getCurrentBackoffMillis() + this.getRandomJitter();
        this.strategy.nextBackoff();
        Thread.sleep(retryDelay);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BackoffStrategy getStrategy() {
        return this.strategy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxJitter() {
        return this.maxJitter;
    }
}

