/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.process.targeting;

import dev.openfeature.contrib.providers.flagd.resolver.process.targeting.Fractional;
import dev.openfeature.contrib.providers.flagd.resolver.process.targeting.SemVer;
import dev.openfeature.contrib.providers.flagd.resolver.process.targeting.StringComp;
import dev.openfeature.contrib.providers.flagd.resolver.process.targeting.TargetingRuleException;
import dev.openfeature.sdk.EvaluationContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.jamsesso.jsonlogic.JsonLogic;
import io.github.jamsesso.jsonlogic.JsonLogicException;
import io.github.jamsesso.jsonlogic.evaluator.JsonLogicExpression;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class Operator {
    static final String FLAGD_PROPS_KEY = "$flagd";
    static final String FLAG_KEY = "flagKey";
    static final String TARGET_KEY = "targetingKey";
    static final String TIME_STAMP = "timestamp";
    private final JsonLogic jsonLogicHandler = new JsonLogic();

    public Operator() {
        this.jsonLogicHandler.addOperation((JsonLogicExpression)new Fractional());
        this.jsonLogicHandler.addOperation((JsonLogicExpression)new SemVer());
        this.jsonLogicHandler.addOperation((JsonLogicExpression)new StringComp(StringComp.Type.STARTS_WITH));
        this.jsonLogicHandler.addOperation((JsonLogicExpression)new StringComp(StringComp.Type.ENDS_WITH));
    }

    public Object apply(String flagKey, String targetingRule, EvaluationContext ctx) throws TargetingRuleException {
        HashMap<String, Object> flagdProperties = new HashMap<String, Object>();
        flagdProperties.put(FLAG_KEY, flagKey);
        long unixTimestamp = Instant.now().getEpochSecond();
        flagdProperties.put(TIME_STAMP, unixTimestamp);
        Map targetingCtxData = ctx.asObjectMap();
        targetingCtxData.put(TARGET_KEY, ctx.getTargetingKey());
        targetingCtxData.put(FLAGD_PROPS_KEY, flagdProperties);
        try {
            return this.jsonLogicHandler.apply(targetingRule, (Object)targetingCtxData);
        }
        catch (JsonLogicException e) {
            throw new TargetingRuleException("Error evaluating json logic", e);
        }
    }

    static class FlagProperties {
        private Object flagKey = null;
        private Object timestamp = null;
        private String targetingKey = null;

        FlagProperties(Object from) {
            Map<?, ?> flagdPropertyMap;
            if (!(from instanceof Map)) {
                return;
            }
            Map dataMap = (Map)from;
            Object targetKey = dataMap.get(Operator.TARGET_KEY);
            if (targetKey instanceof String) {
                this.targetingKey = (String)targetKey;
            }
            if ((flagdPropertyMap = FlagProperties.flagdPropertyMap(dataMap)) == null) {
                return;
            }
            this.flagKey = flagdPropertyMap.get(Operator.FLAG_KEY);
            this.timestamp = flagdPropertyMap.get(Operator.TIME_STAMP);
        }

        private static Map<?, ?> flagdPropertyMap(Map<?, ?> dataMap) {
            Object o = dataMap.get(Operator.FLAGD_PROPS_KEY);
            if (o instanceof Map) {
                return (Map)o;
            }
            return null;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Object getFlagKey() {
            return this.flagKey;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Object getTimestamp() {
            return this.timestamp;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getTargetingKey() {
            return this.targetingKey;
        }
    }
}

