/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd;

import dev.openfeature.contrib.providers.flagd.Config;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.Connector;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.ImmutableContext;
import dev.openfeature.sdk.Structure;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class FlagdOptions {
    private Config.EvaluatorType resolverType;
    private String host;
    private int port;
    private boolean tls;
    private String certPath;
    private String socketPath;
    private String cacheType;
    private int maxCacheSize;
    private int retryBackoffMs;
    private int deadline;
    private int streamDeadlineMs;
    private int retryGracePeriod;
    private String selector;
    private long keepAlive;
    private String offlineFlagSourcePath;
    private int offlinePollIntervalMs;
    private String targetUri;
    private Function<Structure, EvaluationContext> contextEnricher;
    private Connector customConnector;
    private OpenTelemetry openTelemetry;

    public static FlagdOptionsBuilder builder() {
        return new FlagdOptionsBuilder(){

            @Override
            public FlagdOptions build() {
                this.prebuild();
                return super.build();
            }
        };
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static String $default$host() {
        return Config.fallBackToEnvOrDefault("FLAGD_HOST", "localhost");
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static boolean $default$tls() {
        return Boolean.parseBoolean(Config.fallBackToEnvOrDefault("FLAGD_TLS", "false"));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static String $default$certPath() {
        return Config.fallBackToEnvOrDefault("FLAGD_SERVER_CERT_PATH", null);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static String $default$socketPath() {
        return Config.fallBackToEnvOrDefault("FLAGD_SOCKET_PATH", null);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static String $default$cacheType() {
        return Config.fallBackToEnvOrDefault("FLAGD_CACHE", Config.DEFAULT_CACHE);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static int $default$maxCacheSize() {
        return Config.fallBackToEnvOrDefault("FLAGD_MAX_CACHE_SIZE", 1000);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static int $default$retryBackoffMs() {
        return Config.fallBackToEnvOrDefault("FLAGD_RETRY_BACKOFF_MS", 1000);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static int $default$deadline() {
        return Config.fallBackToEnvOrDefault("FLAGD_DEADLINE_MS", 500);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static int $default$streamDeadlineMs() {
        return Config.fallBackToEnvOrDefault("FLAGD_STREAM_DEADLINE_MS", 600000);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static int $default$retryGracePeriod() {
        return Config.fallBackToEnvOrDefault("FLAGD_RETRY_GRACE_PERIOD", 5);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static String $default$selector() {
        return Config.fallBackToEnvOrDefault("FLAGD_SOURCE_SELECTOR", null);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static long $default$keepAlive() {
        return Config.fallBackToEnvOrDefault("FLAGD_KEEP_ALIVE_TIME_MS", Config.fallBackToEnvOrDefault("FLAGD_KEEP_ALIVE_TIME", 0L));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static int $default$offlinePollIntervalMs() {
        return Config.fallBackToEnvOrDefault("FLAGD_OFFLINE_POLL_MS", 5000);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static String $default$targetUri() {
        return Config.fallBackToEnvOrDefault("FLAGD_TARGET_URI", null);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static Function<Structure, EvaluationContext> $default$contextEnricher() {
        return syncMetadata -> new ImmutableContext(syncMetadata.asMap());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    FlagdOptions(Config.EvaluatorType resolverType, String host, int port, boolean tls, String certPath, String socketPath, String cacheType, int maxCacheSize, int retryBackoffMs, int deadline, int streamDeadlineMs, int retryGracePeriod, String selector, long keepAlive, String offlineFlagSourcePath, int offlinePollIntervalMs, String targetUri, Function<Structure, EvaluationContext> contextEnricher, Connector customConnector, OpenTelemetry openTelemetry) {
        this.resolverType = resolverType;
        this.host = host;
        this.port = port;
        this.tls = tls;
        this.certPath = certPath;
        this.socketPath = socketPath;
        this.cacheType = cacheType;
        this.maxCacheSize = maxCacheSize;
        this.retryBackoffMs = retryBackoffMs;
        this.deadline = deadline;
        this.streamDeadlineMs = streamDeadlineMs;
        this.retryGracePeriod = retryGracePeriod;
        this.selector = selector;
        this.keepAlive = keepAlive;
        this.offlineFlagSourcePath = offlineFlagSourcePath;
        this.offlinePollIntervalMs = offlinePollIntervalMs;
        this.targetUri = targetUri;
        this.contextEnricher = contextEnricher;
        this.customConnector = customConnector;
        this.openTelemetry = openTelemetry;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Config.EvaluatorType getResolverType() {
        return this.resolverType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getHost() {
        return this.host;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getPort() {
        return this.port;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isTls() {
        return this.tls;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCertPath() {
        return this.certPath;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSocketPath() {
        return this.socketPath;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCacheType() {
        return this.cacheType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getRetryBackoffMs() {
        return this.retryBackoffMs;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getDeadline() {
        return this.deadline;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getStreamDeadlineMs() {
        return this.streamDeadlineMs;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getRetryGracePeriod() {
        return this.retryGracePeriod;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSelector() {
        return this.selector;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getKeepAlive() {
        return this.keepAlive;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getOfflineFlagSourcePath() {
        return this.offlineFlagSourcePath;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getOfflinePollIntervalMs() {
        return this.offlinePollIntervalMs;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTargetUri() {
        return this.targetUri;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Function<Structure, EvaluationContext> getContextEnricher() {
        return this.contextEnricher;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Connector getCustomConnector() {
        return this.customConnector;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    public static class FlagdOptionsBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Config.EvaluatorType resolverType;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean host$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String host$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int port;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean tls$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean tls$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean certPath$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String certPath$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean socketPath$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String socketPath$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean cacheType$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String cacheType$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean maxCacheSize$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int maxCacheSize$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean retryBackoffMs$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int retryBackoffMs$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean deadline$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int deadline$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean streamDeadlineMs$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int streamDeadlineMs$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean retryGracePeriod$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int retryGracePeriod$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean selector$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String selector$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean keepAlive$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long keepAlive$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String offlineFlagSourcePath;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean offlinePollIntervalMs$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int offlinePollIntervalMs$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean targetUri$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String targetUri$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean contextEnricher$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Function<Structure, EvaluationContext> contextEnricher$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Connector customConnector;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private OpenTelemetry openTelemetry;

        public FlagdOptionsBuilder withGlobalTelemetry(boolean b) {
            if (b) {
                this.openTelemetry = GlobalOpenTelemetry.get();
            }
            return this;
        }

        void prebuild() {
            if (this.resolverType == null) {
                this.resolverType = Config.fromValueProvider(System::getenv);
            }
            if (StringUtils.isBlank((CharSequence)this.offlineFlagSourcePath)) {
                this.offlineFlagSourcePath = Config.fallBackToEnvOrDefault("FLAGD_OFFLINE_FLAG_SOURCE_PATH", null);
            }
            if (!StringUtils.isEmpty((CharSequence)this.offlineFlagSourcePath) && this.resolverType == Config.Resolver.IN_PROCESS) {
                this.resolverType = Config.Resolver.FILE;
            }
            if (StringUtils.isEmpty((CharSequence)this.offlineFlagSourcePath) && this.resolverType == Config.Resolver.FILE) {
                throw new IllegalArgumentException("Resolver Type 'FILE' requires a offlineFlagSourcePath");
            }
            if (this.port == 0 && this.resolverType != Config.Resolver.FILE) {
                this.port = Integer.parseInt(Config.fallBackToEnvOrDefault("FLAGD_PORT", this.determineDefaultPortForResolver()));
            }
        }

        private String determineDefaultPortForResolver() {
            if (this.resolverType.equals(Config.Resolver.RPC)) {
                return "8013";
            }
            return "8015";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        FlagdOptionsBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlagdOptionsBuilder resolverType(Config.EvaluatorType resolverType) {
            this.resolverType = resolverType;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlagdOptionsBuilder host(String host) {
            this.host$value = host;
            this.host$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlagdOptionsBuilder port(int port) {
            this.port = port;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlagdOptionsBuilder tls(boolean tls) {
            this.tls$value = tls;
            this.tls$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlagdOptionsBuilder certPath(String certPath) {
            this.certPath$value = certPath;
            this.certPath$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlagdOptionsBuilder socketPath(String socketPath) {
            this.socketPath$value = socketPath;
            this.socketPath$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlagdOptionsBuilder cacheType(String cacheType) {
            this.cacheType$value = cacheType;
            this.cacheType$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlagdOptionsBuilder maxCacheSize(int maxCacheSize) {
            this.maxCacheSize$value = maxCacheSize;
            this.maxCacheSize$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlagdOptionsBuilder retryBackoffMs(int retryBackoffMs) {
            this.retryBackoffMs$value = retryBackoffMs;
            this.retryBackoffMs$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlagdOptionsBuilder deadline(int deadline) {
            this.deadline$value = deadline;
            this.deadline$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlagdOptionsBuilder streamDeadlineMs(int streamDeadlineMs) {
            this.streamDeadlineMs$value = streamDeadlineMs;
            this.streamDeadlineMs$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlagdOptionsBuilder retryGracePeriod(int retryGracePeriod) {
            this.retryGracePeriod$value = retryGracePeriod;
            this.retryGracePeriod$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlagdOptionsBuilder selector(String selector) {
            this.selector$value = selector;
            this.selector$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlagdOptionsBuilder keepAlive(long keepAlive) {
            this.keepAlive$value = keepAlive;
            this.keepAlive$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlagdOptionsBuilder offlineFlagSourcePath(String offlineFlagSourcePath) {
            this.offlineFlagSourcePath = offlineFlagSourcePath;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlagdOptionsBuilder offlinePollIntervalMs(int offlinePollIntervalMs) {
            this.offlinePollIntervalMs$value = offlinePollIntervalMs;
            this.offlinePollIntervalMs$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlagdOptionsBuilder targetUri(String targetUri) {
            this.targetUri$value = targetUri;
            this.targetUri$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlagdOptionsBuilder contextEnricher(Function<Structure, EvaluationContext> contextEnricher) {
            this.contextEnricher$value = contextEnricher;
            this.contextEnricher$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlagdOptionsBuilder customConnector(Connector customConnector) {
            this.customConnector = customConnector;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlagdOptionsBuilder openTelemetry(OpenTelemetry openTelemetry) {
            this.openTelemetry = openTelemetry;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlagdOptions build() {
            String host$value = this.host$value;
            if (!this.host$set) {
                host$value = FlagdOptions.$default$host();
            }
            boolean tls$value = this.tls$value;
            if (!this.tls$set) {
                tls$value = FlagdOptions.$default$tls();
            }
            String certPath$value = this.certPath$value;
            if (!this.certPath$set) {
                certPath$value = FlagdOptions.$default$certPath();
            }
            String socketPath$value = this.socketPath$value;
            if (!this.socketPath$set) {
                socketPath$value = FlagdOptions.$default$socketPath();
            }
            String cacheType$value = this.cacheType$value;
            if (!this.cacheType$set) {
                cacheType$value = FlagdOptions.$default$cacheType();
            }
            int maxCacheSize$value = this.maxCacheSize$value;
            if (!this.maxCacheSize$set) {
                maxCacheSize$value = FlagdOptions.$default$maxCacheSize();
            }
            int retryBackoffMs$value = this.retryBackoffMs$value;
            if (!this.retryBackoffMs$set) {
                retryBackoffMs$value = FlagdOptions.$default$retryBackoffMs();
            }
            int deadline$value = this.deadline$value;
            if (!this.deadline$set) {
                deadline$value = FlagdOptions.$default$deadline();
            }
            int streamDeadlineMs$value = this.streamDeadlineMs$value;
            if (!this.streamDeadlineMs$set) {
                streamDeadlineMs$value = FlagdOptions.$default$streamDeadlineMs();
            }
            int retryGracePeriod$value = this.retryGracePeriod$value;
            if (!this.retryGracePeriod$set) {
                retryGracePeriod$value = FlagdOptions.$default$retryGracePeriod();
            }
            String selector$value = this.selector$value;
            if (!this.selector$set) {
                selector$value = FlagdOptions.$default$selector();
            }
            long keepAlive$value = this.keepAlive$value;
            if (!this.keepAlive$set) {
                keepAlive$value = FlagdOptions.$default$keepAlive();
            }
            int offlinePollIntervalMs$value = this.offlinePollIntervalMs$value;
            if (!this.offlinePollIntervalMs$set) {
                offlinePollIntervalMs$value = FlagdOptions.$default$offlinePollIntervalMs();
            }
            String targetUri$value = this.targetUri$value;
            if (!this.targetUri$set) {
                targetUri$value = FlagdOptions.$default$targetUri();
            }
            Function contextEnricher$value = this.contextEnricher$value;
            if (!this.contextEnricher$set) {
                contextEnricher$value = FlagdOptions.$default$contextEnricher();
            }
            return new FlagdOptions(this.resolverType, host$value, this.port, tls$value, certPath$value, socketPath$value, cacheType$value, maxCacheSize$value, retryBackoffMs$value, deadline$value, streamDeadlineMs$value, retryGracePeriod$value, selector$value, keepAlive$value, this.offlineFlagSourcePath, offlinePollIntervalMs$value, targetUri$value, contextEnricher$value, this.customConnector, this.openTelemetry);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "FlagdOptions.FlagdOptionsBuilder(resolverType=" + this.resolverType + ", host$value=" + this.host$value + ", port=" + this.port + ", tls$value=" + this.tls$value + ", certPath$value=" + this.certPath$value + ", socketPath$value=" + this.socketPath$value + ", cacheType$value=" + this.cacheType$value + ", maxCacheSize$value=" + this.maxCacheSize$value + ", retryBackoffMs$value=" + this.retryBackoffMs$value + ", deadline$value=" + this.deadline$value + ", streamDeadlineMs$value=" + this.streamDeadlineMs$value + ", retryGracePeriod$value=" + this.retryGracePeriod$value + ", selector$value=" + this.selector$value + ", keepAlive$value=" + this.keepAlive$value + ", offlineFlagSourcePath=" + this.offlineFlagSourcePath + ", offlinePollIntervalMs$value=" + this.offlinePollIntervalMs$value + ", targetUri$value=" + this.targetUri$value + ", contextEnricher$value=" + this.contextEnricher$value + ", customConnector=" + this.customConnector + ", openTelemetry=" + this.openTelemetry + ")";
        }
    }
}

