/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.common;

import dev.openfeature.contrib.providers.flagd.FlagdOptions;
import dev.openfeature.contrib.providers.flagd.resolver.common.ChannelBuilder;
import dev.openfeature.contrib.providers.flagd.resolver.common.ChannelMonitor;
import dev.openfeature.contrib.providers.flagd.resolver.common.FlagdProviderEvent;
import dev.openfeature.sdk.ImmutableStructure;
import dev.openfeature.sdk.ProviderEvent;
import dev.openfeature.sdk.Structure;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.stub.AbstractBlockingStub;
import io.grpc.stub.AbstractStub;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcConnector<T extends AbstractStub<T>, K extends AbstractBlockingStub<K>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrpcConnector.class);
    private final T serviceStub;
    private final K blockingStub;
    private final ManagedChannel channel;
    private final long deadline;
    private final long streamDeadlineMs;
    private final Consumer<FlagdProviderEvent> onConnectionEvent;
    private final Consumer<T> streamObserver;
    private boolean connected = false;

    public GrpcConnector(FlagdOptions options, Function<ManagedChannel, T> stub, Function<ManagedChannel, K> blockingStub, Consumer<FlagdProviderEvent> onConnectionEvent, Consumer<T> eventStreamObserver, ManagedChannel channel) {
        this.channel = channel;
        this.serviceStub = ((AbstractStub)stub.apply(channel)).withWaitForReady();
        this.blockingStub = (AbstractBlockingStub)((AbstractBlockingStub)blockingStub.apply(channel)).withWaitForReady();
        this.deadline = options.getDeadline();
        this.streamDeadlineMs = options.getStreamDeadlineMs();
        this.onConnectionEvent = onConnectionEvent;
        this.streamObserver = eventStreamObserver;
    }

    public GrpcConnector(FlagdOptions options, Function<ManagedChannel, T> stub, Function<ManagedChannel, K> blockingStub, Consumer<FlagdProviderEvent> onConnectionEvent, Consumer<T> eventStreamObserver) {
        this(options, stub, blockingStub, onConnectionEvent, eventStreamObserver, ChannelBuilder.nettyChannel(options));
    }

    public void initialize() throws Exception {
        log.info("Initializing GRPC connection...");
        ChannelMonitor.monitorChannelState(ConnectivityState.READY, this.channel, this::onReady, this::onConnectionLost);
    }

    public K getResolver() {
        return this.blockingStub;
    }

    public void shutdown() throws InterruptedException {
        log.info("Shutting down GRPC connection...");
        if (!this.channel.isShutdown()) {
            this.channel.shutdownNow();
            this.channel.awaitTermination(this.deadline, TimeUnit.MILLISECONDS);
        }
    }

    private synchronized void onReady() {
        this.connected = true;
        this.restartStream();
    }

    private synchronized void onConnectionLost() {
        this.connected = false;
        this.onConnectionEvent.accept(new FlagdProviderEvent(ProviderEvent.PROVIDER_ERROR, Collections.emptyList(), (Structure)new ImmutableStructure()));
    }

    private synchronized void restartStream() {
        if (this.connected) {
            log.debug("(Re)initializing event stream.");
            Object localServiceStub = this.serviceStub;
            if (this.streamDeadlineMs > 0L) {
                localServiceStub = localServiceStub.withDeadlineAfter(this.streamDeadlineMs, TimeUnit.MILLISECONDS);
            }
            this.streamObserver.accept(localServiceStub);
            return;
        }
        log.debug("Stream restart skipped. Not connected.");
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isConnected() {
        return this.connected;
    }
}

