/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.grpc;

import com.google.protobuf.Value;
import dev.openfeature.contrib.providers.flagd.resolver.common.FlagdProviderEvent;
import dev.openfeature.flagd.grpc.evaluation.Evaluation;
import dev.openfeature.sdk.ProviderEvent;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(justification="cache needs to be read and write by multiple objects")
class EventStreamObserver
implements StreamObserver<Evaluation.EventStreamResponse> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventStreamObserver.class);
    private final Consumer<List<String>> onConfigurationChange;
    private final Consumer<FlagdProviderEvent> onReady;

    EventStreamObserver(Consumer<List<String>> onConfigurationChange, Consumer<FlagdProviderEvent> onReady) {
        this.onConfigurationChange = onConfigurationChange;
        this.onReady = onReady;
    }

    public void onNext(Evaluation.EventStreamResponse value) {
        switch (value.getType()) {
            case "configuration_change": {
                this.handleConfigurationChangeEvent(value);
                break;
            }
            case "provider_ready": {
                this.handleProviderReadyEvent();
                break;
            }
            default: {
                log.debug("Unhandled event type {}", (Object)value.getType());
            }
        }
    }

    public void onError(Throwable throwable) {
    }

    public void onCompleted() {
    }

    private void handleConfigurationChangeEvent(Evaluation.EventStreamResponse value) {
        log.debug("Received provider change event");
        ArrayList changedFlags = new ArrayList();
        Map data = value.getData().getFieldsMap();
        Value flagsValue = (Value)data.get("flags");
        if (flagsValue != null) {
            Map flags = flagsValue.getStructValue().getFieldsMap();
            changedFlags.addAll(flags.keySet());
        }
        this.onConfigurationChange.accept(changedFlags);
    }

    private void handleProviderReadyEvent() {
        log.debug("Received provider ready event");
        this.onReady.accept(new FlagdProviderEvent(ProviderEvent.PROVIDER_READY));
    }
}

