/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd;

import dev.openfeature.contrib.providers.flagd.FlagdOptions;
import dev.openfeature.contrib.providers.flagd.FlagdProviderSyncResources;
import dev.openfeature.contrib.providers.flagd.SyncMetadataHook;
import dev.openfeature.contrib.providers.flagd.resolver.Resolver;
import dev.openfeature.contrib.providers.flagd.resolver.common.FlagdProviderEvent;
import dev.openfeature.contrib.providers.flagd.resolver.grpc.GrpcResolver;
import dev.openfeature.contrib.providers.flagd.resolver.grpc.cache.Cache;
import dev.openfeature.contrib.providers.flagd.resolver.process.InProcessResolver;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.EventProvider;
import dev.openfeature.sdk.Hook;
import dev.openfeature.sdk.Metadata;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.ProviderEvent;
import dev.openfeature.sdk.ProviderEventDetails;
import dev.openfeature.sdk.Structure;
import dev.openfeature.sdk.Value;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlagdProvider
extends EventProvider {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlagdProvider.class);
    private Function<Structure, EvaluationContext> contextEnricher;
    private static final String FLAGD_PROVIDER = "flagd";
    private final Resolver flagResolver;
    private final List<Hook> hooks = new ArrayList<Hook>();
    private final FlagdProviderSyncResources syncResources = new FlagdProviderSyncResources();
    private final ScheduledExecutorService errorExecutor;
    private ScheduledFuture<?> errorTask;
    private final long gracePeriod;
    private final long deadline;

    protected final void finalize() {
    }

    public FlagdProvider() {
        this(FlagdOptions.builder().build());
    }

    public FlagdProvider(FlagdOptions options) {
        switch (options.getResolverType().asString()) {
            case "file": 
            case "in-process": {
                this.flagResolver = new InProcessResolver(options, this::onProviderEvent);
                break;
            }
            case "rpc": {
                this.flagResolver = new GrpcResolver(options, new Cache(options.getCacheType(), options.getMaxCacheSize()), this::onProviderEvent);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Requested unsupported resolver type of %s", options.getResolverType()));
            }
        }
        this.hooks.add(new SyncMetadataHook(this::getEnrichedContext));
        this.contextEnricher = options.getContextEnricher();
        this.errorExecutor = Executors.newSingleThreadScheduledExecutor();
        this.gracePeriod = options.getRetryGracePeriod();
        this.deadline = options.getDeadline();
    }

    FlagdProvider(Resolver resolver, boolean initialized) {
        this.flagResolver = resolver;
        this.deadline = 500L;
        this.gracePeriod = 5L;
        this.hooks.add(new SyncMetadataHook(this::getEnrichedContext));
        this.errorExecutor = Executors.newSingleThreadScheduledExecutor();
        if (initialized) {
            this.syncResources.initialize();
        }
    }

    public List<Hook> getProviderHooks() {
        return Collections.unmodifiableList(this.hooks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(EvaluationContext evaluationContext) throws Exception {
        FlagdProviderSyncResources flagdProviderSyncResources = this.syncResources;
        synchronized (flagdProviderSyncResources) {
            if (this.syncResources.isInitialized()) {
                return;
            }
            this.flagResolver.init();
            this.syncResources.waitForInitialization(this.deadline * 2L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        FlagdProviderSyncResources flagdProviderSyncResources = this.syncResources;
        synchronized (flagdProviderSyncResources) {
            try {
                if (!this.syncResources.isInitialized() || this.syncResources.isShutDown()) {
                    return;
                }
                this.flagResolver.shutdown();
                if (this.errorExecutor != null) {
                    this.errorExecutor.shutdownNow();
                    this.errorExecutor.awaitTermination(this.deadline, TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception e) {
                log.error("Error during shutdown {}", (Object)FLAGD_PROVIDER, (Object)e);
            }
            finally {
                this.syncResources.shutdown();
            }
        }
    }

    public Metadata getMetadata() {
        return () -> FLAGD_PROVIDER;
    }

    public ProviderEvaluation<Boolean> getBooleanEvaluation(String key, Boolean defaultValue, EvaluationContext ctx) {
        return this.flagResolver.booleanEvaluation(key, defaultValue, ctx);
    }

    public ProviderEvaluation<String> getStringEvaluation(String key, String defaultValue, EvaluationContext ctx) {
        return this.flagResolver.stringEvaluation(key, defaultValue, ctx);
    }

    public ProviderEvaluation<Double> getDoubleEvaluation(String key, Double defaultValue, EvaluationContext ctx) {
        return this.flagResolver.doubleEvaluation(key, defaultValue, ctx);
    }

    public ProviderEvaluation<Integer> getIntegerEvaluation(String key, Integer defaultValue, EvaluationContext ctx) {
        return this.flagResolver.integerEvaluation(key, defaultValue, ctx);
    }

    public ProviderEvaluation<Value> getObjectEvaluation(String key, Value defaultValue, EvaluationContext ctx) {
        return this.flagResolver.objectEvaluation(key, defaultValue, ctx);
    }

    EvaluationContext getEnrichedContext() {
        return this.syncResources.getEnrichedContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onProviderEvent(FlagdProviderEvent flagdProviderEvent) {
        log.info("FlagdProviderEvent event {} ", (Object)flagdProviderEvent.getEvent());
        FlagdProviderSyncResources flagdProviderSyncResources = this.syncResources;
        synchronized (flagdProviderSyncResources) {
            switch (flagdProviderEvent.getEvent()) {
                case PROVIDER_CONFIGURATION_CHANGED: {
                    if (this.syncResources.getPreviousEvent() == ProviderEvent.PROVIDER_READY) {
                        this.onConfigurationChanged(flagdProviderEvent);
                        break;
                    }
                }
                case PROVIDER_READY: {
                    if (flagdProviderEvent.getSyncMetadata() != null) {
                        this.syncResources.setEnrichedContext(this.contextEnricher.apply(flagdProviderEvent.getSyncMetadata()));
                    }
                    this.onReady();
                    this.syncResources.setPreviousEvent(ProviderEvent.PROVIDER_READY);
                    break;
                }
                case PROVIDER_ERROR: {
                    if (this.syncResources.getPreviousEvent() == ProviderEvent.PROVIDER_ERROR) break;
                    this.onError();
                    this.syncResources.setPreviousEvent(ProviderEvent.PROVIDER_ERROR);
                    break;
                }
                default: {
                    log.info("Unknown event {}", (Object)flagdProviderEvent.getEvent());
                }
            }
        }
    }

    private void onConfigurationChanged(FlagdProviderEvent flagdProviderEvent) {
        this.emitProviderConfigurationChanged(ProviderEventDetails.builder().flagsChanged(flagdProviderEvent.getFlagsChanged()).message("configuration changed").build());
    }

    private void onReady() {
        if (this.syncResources.initialize()) {
            log.info("initialized FlagdProvider");
        }
        if (this.errorTask != null && !this.errorTask.isCancelled()) {
            this.errorTask.cancel(false);
            log.debug("Reconnection task cancelled as connection became READY.");
        }
        this.emitProviderReady(ProviderEventDetails.builder().message("connected to flagd").build());
    }

    private void onError() {
        log.info("Connection lost. Emit STALE event...");
        log.debug("Waiting {}s for connection to become available...", (Object)this.gracePeriod);
        this.emitProviderStale(ProviderEventDetails.builder().message("there has been an error").build());
        if (this.errorTask != null && !this.errorTask.isCancelled()) {
            this.errorTask.cancel(false);
        }
        if (!this.errorExecutor.isShutdown()) {
            this.errorTask = this.errorExecutor.schedule(() -> {
                if (this.syncResources.getPreviousEvent() == ProviderEvent.PROVIDER_ERROR) {
                    log.debug("Provider did not reconnect successfully within {}s. Emit ERROR event...", (Object)this.gracePeriod);
                    this.flagResolver.onError();
                    this.emitProviderError(ProviderEventDetails.builder().message("there has been an error").build());
                }
            }, this.gracePeriod, TimeUnit.SECONDS);
        }
    }
}

