/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.common;

import dev.openfeature.sdk.exceptions.GeneralError;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelMonitor {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChannelMonitor.class);

    private ChannelMonitor() {
    }

    public static void monitorChannelState(ConnectivityState expectedState, ManagedChannel channel, Runnable onConnectionReady, Runnable onConnectionLost) {
        channel.notifyWhenStateChanged(expectedState, () -> {
            ConnectivityState currentState = channel.getState(true);
            log.debug("Channel state changed to: {}", (Object)currentState);
            if (currentState == ConnectivityState.READY) {
                if (onConnectionReady != null) {
                    onConnectionReady.run();
                } else {
                    log.debug("onConnectionReady is null");
                }
            } else if (currentState == ConnectivityState.TRANSIENT_FAILURE || currentState == ConnectivityState.SHUTDOWN) {
                if (onConnectionLost != null) {
                    onConnectionLost.run();
                } else {
                    log.debug("onConnectionLost is null");
                }
            }
            if (currentState != ConnectivityState.SHUTDOWN) {
                log.debug("continuing to monitor the grpc channel");
                ChannelMonitor.monitorChannelState(currentState, channel, onConnectionReady, onConnectionLost);
            }
        });
    }

    public static void waitForDesiredState(ConnectivityState desiredState, ManagedChannel channel, Runnable connectCallback, long timeout, TimeUnit unit) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        Runnable waitForStateTask = () -> {
            ConnectivityState currentState = channel.getState(true);
            if (currentState == desiredState) {
                connectCallback.run();
                latch.countDown();
            }
        };
        ScheduledFuture<?> scheduledFuture = Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(waitForStateTask, 0L, 100L, TimeUnit.MILLISECONDS);
        boolean success = latch.await(timeout, unit);
        scheduledFuture.cancel(true);
        if (!success) {
            throw new GeneralError(String.format("Deadline exceeded. Condition did not complete within the %d deadline", timeout));
        }
    }
}

