/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.common;

import dev.openfeature.sdk.ImmutableStructure;
import dev.openfeature.sdk.ProviderEvent;
import dev.openfeature.sdk.Structure;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class FlagdProviderEvent {
    private final ProviderEvent event;
    private final List<String> flagsChanged;
    private final Structure syncMetadata;

    public FlagdProviderEvent(ProviderEvent event) {
        this(event, Collections.emptyList(), (Structure)new ImmutableStructure());
    }

    public FlagdProviderEvent(ProviderEvent event, List<String> flagsChanged) {
        this(event, flagsChanged, (Structure)new ImmutableStructure());
    }

    public FlagdProviderEvent(ProviderEvent event, Structure syncMetadata) {
        this(event, Collections.emptyList(), (Structure)new ImmutableStructure(syncMetadata.asMap()));
    }

    public FlagdProviderEvent(ProviderEvent event, List<String> flagsChanged, Structure syncMetadata) {
        this.event = event;
        this.flagsChanged = flagsChanged != null ? flagsChanged : Collections.emptyList();
        this.syncMetadata = syncMetadata != null ? new ImmutableStructure(syncMetadata.asMap()) : new ImmutableStructure();
    }

    public List<String> getFlagsChanged() {
        return Collections.unmodifiableList(this.flagsChanged);
    }

    public Structure getSyncMetadata() {
        return new ImmutableStructure(this.syncMetadata.asMap());
    }

    public boolean isDisconnected() {
        return this.event == ProviderEvent.PROVIDER_ERROR || this.event == ProviderEvent.PROVIDER_STALE;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ProviderEvent getEvent() {
        return this.event;
    }
}

