/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.grpc;

import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import dev.openfeature.contrib.providers.flagd.FlagdOptions;
import dev.openfeature.contrib.providers.flagd.resolver.Resolver;
import dev.openfeature.contrib.providers.flagd.resolver.common.FlagdProviderEvent;
import dev.openfeature.contrib.providers.flagd.resolver.common.GrpcConnector;
import dev.openfeature.contrib.providers.flagd.resolver.grpc.Convert;
import dev.openfeature.contrib.providers.flagd.resolver.grpc.EventStreamObserver;
import dev.openfeature.contrib.providers.flagd.resolver.grpc.cache.Cache;
import dev.openfeature.contrib.providers.flagd.resolver.grpc.strategy.ResolveFactory;
import dev.openfeature.contrib.providers.flagd.resolver.grpc.strategy.ResolveStrategy;
import dev.openfeature.flagd.grpc.evaluation.Evaluation;
import dev.openfeature.flagd.grpc.evaluation.ServiceGrpc;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.ImmutableMetadata;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.ProviderEvent;
import dev.openfeature.sdk.Value;
import dev.openfeature.sdk.exceptions.FlagNotFoundError;
import dev.openfeature.sdk.exceptions.GeneralError;
import dev.openfeature.sdk.exceptions.OpenFeatureError;
import dev.openfeature.sdk.exceptions.ParseError;
import dev.openfeature.sdk.exceptions.TypeMismatchError;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;

@SuppressFBWarnings(justification="cache needs to be read and write by multiple objects")
public final class GrpcResolver
implements Resolver {
    private final GrpcConnector<ServiceGrpc.ServiceStub, ServiceGrpc.ServiceBlockingStub> connector;
    private final Cache cache;
    private final ResolveStrategy strategy;
    private final FlagdOptions options;

    public GrpcResolver(FlagdOptions options, Cache cache, Consumer<FlagdProviderEvent> onProviderEvent) {
        this.cache = cache;
        this.strategy = ResolveFactory.getStrategy(options);
        this.options = options;
        this.connector = new GrpcConnector<ServiceGrpc.ServiceStub, ServiceGrpc.ServiceBlockingStub>(options, ServiceGrpc::newStub, ServiceGrpc::newBlockingStub, onProviderEvent, stub -> stub.eventStream(Evaluation.EventStreamRequest.getDefaultInstance(), new EventStreamObserver(flags -> {
            if (this.cache != null) {
                flags.forEach(this.cache::remove);
            }
            onProviderEvent.accept(new FlagdProviderEvent(ProviderEvent.PROVIDER_CONFIGURATION_CHANGED, (List<String>)flags));
        }, onProviderEvent)));
    }

    @Override
    public void init() throws Exception {
        this.connector.initialize();
    }

    @Override
    public void shutdown() throws Exception {
        this.connector.shutdown();
    }

    @Override
    public void onError() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Override
    public ProviderEvaluation<Boolean> booleanEvaluation(String key, Boolean defaultValue, EvaluationContext ctx) {
        Evaluation.ResolveBooleanRequest request = Evaluation.ResolveBooleanRequest.newBuilder().buildPartial();
        return this.resolve(key, ctx, request, this.getResolver()::resolveBoolean, null);
    }

    @Override
    public ProviderEvaluation<String> stringEvaluation(String key, String defaultValue, EvaluationContext ctx) {
        Evaluation.ResolveStringRequest request = Evaluation.ResolveStringRequest.newBuilder().buildPartial();
        return this.resolve(key, ctx, request, this.getResolver()::resolveString, null);
    }

    @Override
    public ProviderEvaluation<Double> doubleEvaluation(String key, Double defaultValue, EvaluationContext ctx) {
        Evaluation.ResolveFloatRequest request = Evaluation.ResolveFloatRequest.newBuilder().buildPartial();
        return this.resolve(key, ctx, request, this.getResolver()::resolveFloat, null);
    }

    @Override
    public ProviderEvaluation<Integer> integerEvaluation(String key, Integer defaultValue, EvaluationContext ctx) {
        Evaluation.ResolveIntRequest request = Evaluation.ResolveIntRequest.newBuilder().buildPartial();
        return this.resolve(key, ctx, request, this.getResolver()::resolveInt, value -> ((Long)value).intValue());
    }

    private ServiceGrpc.ServiceBlockingStub getResolver() {
        return (ServiceGrpc.ServiceBlockingStub)this.connector.getResolver().withDeadlineAfter(this.options.getDeadline(), TimeUnit.MILLISECONDS);
    }

    @Override
    public ProviderEvaluation<Value> objectEvaluation(String key, Value defaultValue, EvaluationContext ctx) {
        Evaluation.ResolveObjectRequest request = Evaluation.ResolveObjectRequest.newBuilder().buildPartial();
        return this.resolve(key, ctx, request, this.getResolver()::resolveObject, value -> dev.openfeature.contrib.providers.flagd.resolver.common.Convert.convertObjectResponse((Struct)value));
    }

    private <ValT, ReqT extends Message, ResT extends Message> ProviderEvaluation<ValT> resolve(String key, EvaluationContext ctx, ReqT request, Function<ReqT, ResT> resolverRef, Convert<ValT, Object> converter) {
        ResT response;
        ProviderEvaluation<?> fromCache;
        if (this.cacheAvailable().booleanValue() && (fromCache = this.cache.get(key)) != null) {
            fromCache.setReason("CACHED");
            return fromCache;
        }
        Message req = request.newBuilderForType().setField(dev.openfeature.contrib.providers.flagd.resolver.common.Convert.getFieldDescriptor(request, "flag_key"), (Object)key).setField(dev.openfeature.contrib.providers.flagd.resolver.common.Convert.getFieldDescriptor(request, "context"), (Object)dev.openfeature.contrib.providers.flagd.resolver.common.Convert.convertContext(ctx)).build();
        try {
            response = this.strategy.resolve(resolverRef, req, key);
        }
        catch (Exception e) {
            OpenFeatureError openFeatureError = this.mapError(e);
            throw openFeatureError;
        }
        Object value = converter == null ? dev.openfeature.contrib.providers.flagd.resolver.common.Convert.getField(response, "value") : converter.convert(dev.openfeature.contrib.providers.flagd.resolver.common.Convert.getField(response, "value"));
        ImmutableMetadata immutableMetadata = GrpcResolver.metadataFromResponse(response);
        ProviderEvaluation result = ProviderEvaluation.builder().value(value).variant((String)dev.openfeature.contrib.providers.flagd.resolver.common.Convert.getField(response, "variant")).reason((String)dev.openfeature.contrib.providers.flagd.resolver.common.Convert.getField(response, "reason")).flagMetadata(immutableMetadata).build();
        if (this.isEvaluationCacheable(result).booleanValue()) {
            this.cache.put(key, result);
        }
        return result;
    }

    private <T> Boolean isEvaluationCacheable(ProviderEvaluation<T> evaluation) {
        String reason = evaluation.getReason();
        return reason != null && reason.equals("STATIC") && this.cacheAvailable() != false;
    }

    private Boolean cacheAvailable() {
        return this.cache.getEnabled();
    }

    private static ImmutableMetadata metadataFromResponse(Message response) {
        Object metadata = response.getField(dev.openfeature.contrib.providers.flagd.resolver.common.Convert.getFieldDescriptor(response, "metadata"));
        if (!(metadata instanceof Struct)) {
            return ImmutableMetadata.builder().build();
        }
        Struct struct = (Struct)metadata;
        ImmutableMetadata.ImmutableMetadataBuilder builder = ImmutableMetadata.builder();
        for (Map.Entry entry : struct.getFieldsMap().entrySet()) {
            if (((com.google.protobuf.Value)entry.getValue()).hasStringValue()) {
                builder.addString((String)entry.getKey(), ((com.google.protobuf.Value)entry.getValue()).getStringValue());
                continue;
            }
            if (((com.google.protobuf.Value)entry.getValue()).hasBoolValue()) {
                builder.addBoolean((String)entry.getKey(), Boolean.valueOf(((com.google.protobuf.Value)entry.getValue()).getBoolValue()));
                continue;
            }
            if (!((com.google.protobuf.Value)entry.getValue()).hasNumberValue()) continue;
            builder.addDouble((String)entry.getKey(), Double.valueOf(((com.google.protobuf.Value)entry.getValue()).getNumberValue()));
        }
        return builder.build();
    }

    private OpenFeatureError mapError(Exception e) {
        if (e instanceof StatusRuntimeException) {
            Status.Code code = ((StatusRuntimeException)e).getStatus().getCode();
            switch (code) {
                case DATA_LOSS: {
                    return new ParseError(e.getMessage());
                }
                case INVALID_ARGUMENT: {
                    return new TypeMismatchError(e.getMessage());
                }
                case NOT_FOUND: {
                    return new FlagNotFoundError(e.getMessage());
                }
            }
            return new GeneralError(e.getMessage());
        }
        return new GeneralError(e.getMessage());
    }
}

