/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd;

import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.ImmutableContext;
import dev.openfeature.sdk.ProviderEvent;
import dev.openfeature.sdk.exceptions.GeneralError;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;

class FlagdProviderSyncResources {
    private volatile ProviderEvent previousEvent = null;
    private volatile EvaluationContext enrichedContext = new ImmutableContext();
    private volatile boolean initialized;
    private volatile boolean isShutDown;

    FlagdProviderSyncResources() {
    }

    public void setEnrichedContext(EvaluationContext context) {
        this.enrichedContext = new ImmutableContext(context.asMap());
    }

    public synchronized boolean initialize() {
        if (this.initialized) {
            return false;
        }
        this.initialized = true;
        this.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForInitialization(long deadline) {
        long start = System.currentTimeMillis();
        long end = start + deadline;
        while (!this.initialized && !this.isShutDown) {
            long now = System.currentTimeMillis();
            if (now >= end) {
                throw new GeneralError(String.format("Initialization timeout exceeded; did not complete within the %d ms deadline.", deadline));
            }
            long remaining = end - now;
            FlagdProviderSyncResources flagdProviderSyncResources = this;
            synchronized (flagdProviderSyncResources) {
                if (this.isShutDown) {
                    break;
                }
                if (this.initialized) {
                    return;
                }
                try {
                    this.wait(remaining);
                }
                catch (InterruptedException e) {
                }
            }
        }
        if (this.isShutDown) {
            throw new IllegalStateException("Already shut down");
        }
    }

    public synchronized void shutdown() {
        this.isShutDown = true;
        this.notifyAll();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ProviderEvent getPreviousEvent() {
        return this.previousEvent;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public EvaluationContext getEnrichedContext() {
        return this.enrichedContext;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isInitialized() {
        return this.initialized;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isShutDown() {
        return this.isShutDown;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPreviousEvent(ProviderEvent previousEvent) {
        this.previousEvent = previousEvent;
    }
}

