/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.common;

import dev.openfeature.contrib.providers.flagd.FlagdOptions;
import dev.openfeature.contrib.providers.flagd.resolver.common.ChannelBuilder;
import dev.openfeature.contrib.providers.flagd.resolver.common.FlagdProviderEvent;
import dev.openfeature.sdk.ImmutableStructure;
import dev.openfeature.sdk.ProviderEvent;
import dev.openfeature.sdk.Structure;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.stub.AbstractBlockingStub;
import io.grpc.stub.AbstractStub;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelConnector<T extends AbstractStub<T>, K extends AbstractBlockingStub<K>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChannelConnector.class);
    private final ManagedChannel channel;
    private final long deadline;
    private final Consumer<FlagdProviderEvent> onConnectionEvent;

    public ChannelConnector(FlagdOptions options, Consumer<FlagdProviderEvent> onConnectionEvent, ManagedChannel channel) {
        this.channel = channel;
        this.deadline = options.getDeadline();
        this.onConnectionEvent = onConnectionEvent;
    }

    public ChannelConnector(FlagdOptions options, Consumer<FlagdProviderEvent> onConnectionEvent) {
        this(options, onConnectionEvent, ChannelBuilder.nettyChannel(options));
    }

    public void initialize() throws Exception {
        log.info("Initializing GRPC connection.");
        this.monitorChannelState(ConnectivityState.READY);
    }

    public void shutdown() throws InterruptedException {
        log.info("Shutting down GRPC connection.");
        if (!this.channel.isShutdown()) {
            this.channel.shutdownNow();
            this.channel.awaitTermination(this.deadline, TimeUnit.MILLISECONDS);
        }
    }

    private void monitorChannelState(ConnectivityState expectedState) {
        this.channel.notifyWhenStateChanged(expectedState, this::onStateChange);
    }

    private void onStateChange() {
        ConnectivityState currentState = this.channel.getState(true);
        log.debug("Channel state changed to: {}", (Object)currentState);
        if (currentState == ConnectivityState.TRANSIENT_FAILURE || currentState == ConnectivityState.SHUTDOWN) {
            this.onConnectionEvent.accept(new FlagdProviderEvent(ProviderEvent.PROVIDER_ERROR, Collections.emptyList(), (Structure)new ImmutableStructure()));
        }
        if (currentState != ConnectivityState.SHUTDOWN) {
            log.debug("continuing to monitor the grpc channel");
            this.monitorChannelState(currentState);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ManagedChannel getChannel() {
        return this.channel;
    }
}

