/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.common;

import dev.openfeature.contrib.providers.flagd.resolver.common.StreamResponseModel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.BlockingQueue;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="Internal class")
public class QueueingStreamObserver<T>
implements StreamObserver<T> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueueingStreamObserver.class);
    private final BlockingQueue<StreamResponseModel<T>> blockingQueue;

    public QueueingStreamObserver(BlockingQueue<StreamResponseModel<T>> queue) {
        this.blockingQueue = queue;
        queue.clear();
    }

    public void onNext(T response) {
        if (!this.blockingQueue.offer(new StreamResponseModel<T>(response))) {
            log.warn("failed to write sync response to queue");
        }
    }

    public void onError(Throwable throwable) {
        if (!this.blockingQueue.offer(new StreamResponseModel(throwable))) {
            log.warn("failed to write error response to queue");
        }
    }

    public void onCompleted() {
        if (!this.blockingQueue.offer(new StreamResponseModel(true))) {
            log.warn("failed to write complete status to queue");
        }
    }
}

