/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.process;

import dev.openfeature.contrib.providers.flagd.FlagdOptions;
import dev.openfeature.contrib.providers.flagd.resolver.Resolver;
import dev.openfeature.contrib.providers.flagd.resolver.common.FlagdProviderEvent;
import dev.openfeature.contrib.providers.flagd.resolver.process.model.FeatureFlag;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.FlagStore;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.Storage;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.StorageQueryResult;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.StorageStateChange;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.QueueSource;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.file.FileQueueSource;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.sync.SyncStreamQueueSource;
import dev.openfeature.contrib.providers.flagd.resolver.process.targeting.Operator;
import dev.openfeature.contrib.providers.flagd.resolver.process.targeting.TargetingRuleException;
import dev.openfeature.sdk.ErrorCode;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.ImmutableMetadata;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.ProviderEvent;
import dev.openfeature.sdk.Reason;
import dev.openfeature.sdk.Value;
import dev.openfeature.sdk.exceptions.ParseError;
import dev.openfeature.sdk.exceptions.TypeMismatchError;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InProcessResolver
implements Resolver {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InProcessResolver.class);
    private final Storage flagStore;
    private final Consumer<FlagdProviderEvent> onConnectionEvent;
    private final Operator operator;
    private final String scope;

    public InProcessResolver(FlagdOptions options, Consumer<FlagdProviderEvent> onConnectionEvent) {
        this.flagStore = new FlagStore(InProcessResolver.getConnector(options, onConnectionEvent));
        this.onConnectionEvent = onConnectionEvent;
        this.operator = new Operator();
        this.scope = options.getSelector();
    }

    @Override
    public void init() throws Exception {
        this.flagStore.init();
        Thread stateWatcher = new Thread(() -> {
            try {
                block6: while (true) {
                    StorageStateChange storageStateChange = this.flagStore.getStateQueue().take();
                    switch (storageStateChange.getStorageState()) {
                        case OK: {
                            log.debug("onConnectionEvent.accept ProviderEvent.PROVIDER_CONFIGURATION_CHANGED");
                            this.onConnectionEvent.accept(new FlagdProviderEvent(ProviderEvent.PROVIDER_CONFIGURATION_CHANGED, storageStateChange.getChangedFlagsKeys(), storageStateChange.getSyncMetadata()));
                            log.debug("post onConnectionEvent.accept ProviderEvent.PROVIDER_CONFIGURATION_CHANGED");
                            continue block6;
                        }
                        case ERROR: {
                            this.onConnectionEvent.accept(new FlagdProviderEvent(ProviderEvent.PROVIDER_ERROR));
                            continue block6;
                        }
                    }
                    log.warn(String.format("Storage emitted unhandled status: %s", new Object[]{storageStateChange.getStorageState()}));
                }
            }
            catch (InterruptedException e) {
                log.warn("Storage state watcher interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
                return;
            }
        });
        stateWatcher.setDaemon(true);
        stateWatcher.start();
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.flagStore.shutdown();
    }

    @Override
    public ProviderEvaluation<Boolean> booleanEvaluation(String key, Boolean defaultValue, EvaluationContext ctx) {
        return this.resolve(Boolean.class, key, ctx);
    }

    @Override
    public ProviderEvaluation<String> stringEvaluation(String key, String defaultValue, EvaluationContext ctx) {
        return this.resolve(String.class, key, ctx);
    }

    @Override
    public ProviderEvaluation<Double> doubleEvaluation(String key, Double defaultValue, EvaluationContext ctx) {
        return this.resolve(Double.class, key, ctx);
    }

    @Override
    public ProviderEvaluation<Integer> integerEvaluation(String key, Integer defaultValue, EvaluationContext ctx) {
        return this.resolve(Integer.class, key, ctx);
    }

    @Override
    public ProviderEvaluation<Value> objectEvaluation(String key, Value defaultValue, EvaluationContext ctx) {
        ProviderEvaluation<Object> evaluation = this.resolve(Object.class, key, ctx);
        return ProviderEvaluation.builder().value((Object)Value.objectToValue((Object)evaluation.getValue())).variant(evaluation.getVariant()).reason(evaluation.getReason()).errorCode(evaluation.getErrorCode()).errorMessage(evaluation.getErrorMessage()).flagMetadata(evaluation.getFlagMetadata()).build();
    }

    static QueueSource getConnector(FlagdOptions options, Consumer<FlagdProviderEvent> onConnectionEvent) {
        if (options.getCustomConnector() != null) {
            return options.getCustomConnector();
        }
        return options.getOfflineFlagSourcePath() != null && !options.getOfflineFlagSourcePath().isEmpty() ? new FileQueueSource(options.getOfflineFlagSourcePath(), options.getOfflinePollIntervalMs()) : new SyncStreamQueueSource(options, onConnectionEvent);
    }

    private <T> ProviderEvaluation<T> resolve(Class<T> type, String key, EvaluationContext ctx) {
        String reason;
        String resolvedVariant;
        StorageQueryResult storageQueryResult = this.flagStore.getFlag(key);
        FeatureFlag flag = storageQueryResult.getFeatureFlag();
        if (flag == null) {
            return ProviderEvaluation.builder().errorMessage("flag: " + key + " not found").errorCode(ErrorCode.FLAG_NOT_FOUND).flagMetadata(this.getFlagMetadata(storageQueryResult)).build();
        }
        if ("DISABLED".equals(flag.getState())) {
            return ProviderEvaluation.builder().errorMessage("flag: " + key + " is disabled").errorCode(ErrorCode.FLAG_NOT_FOUND).flagMetadata(this.getFlagMetadata(storageQueryResult)).build();
        }
        if ("{}".equals(flag.getTargeting())) {
            resolvedVariant = flag.getDefaultVariant();
            reason = Reason.STATIC.toString();
        } else {
            try {
                Object jsonResolved = this.operator.apply(key, flag.getTargeting(), ctx);
                if (jsonResolved == null) {
                    resolvedVariant = flag.getDefaultVariant();
                    reason = Reason.DEFAULT.toString();
                } else {
                    resolvedVariant = jsonResolved.toString();
                    reason = Reason.TARGETING_MATCH.toString();
                }
            }
            catch (TargetingRuleException e) {
                String message = String.format("error evaluating targeting rule for flag %s", key);
                log.debug(message, (Throwable)e);
                throw new ParseError(message);
            }
        }
        Object value = flag.getVariants().get(resolvedVariant);
        if (value == null) {
            String message = String.format("variant %s not found in flag with key %s", resolvedVariant, key);
            log.debug(message);
            throw new TypeMismatchError(message);
        }
        if (value instanceof Integer && type == Double.class) {
            value = ((Integer)value).doubleValue();
        } else if (value instanceof Double && type == Integer.class) {
            value = ((Double)value).intValue();
        }
        if (!type.isAssignableFrom(value.getClass())) {
            String message = "returning default variant for flagKey: %s, type not valid";
            log.debug(String.format(message, key));
            throw new TypeMismatchError(message);
        }
        return ProviderEvaluation.builder().value(value).variant(resolvedVariant).reason(reason).flagMetadata(this.getFlagMetadata(storageQueryResult)).build();
    }

    private ImmutableMetadata getFlagMetadata(StorageQueryResult storageQueryResult) {
        FeatureFlag flag;
        ImmutableMetadata.ImmutableMetadataBuilder metadataBuilder = ImmutableMetadata.builder();
        for (Map.Entry<String, Object> entry : storageQueryResult.getFlagSetMetadata().entrySet()) {
            this.addEntryToMetadataBuilder(metadataBuilder, entry.getKey(), entry.getValue());
        }
        if (this.scope != null) {
            metadataBuilder.addString("scope", this.scope);
        }
        if ((flag = storageQueryResult.getFeatureFlag()) != null) {
            for (Map.Entry<String, Object> entry : flag.getMetadata().entrySet()) {
                this.addEntryToMetadataBuilder(metadataBuilder, entry.getKey(), entry.getValue());
            }
        }
        return metadataBuilder.build();
    }

    private void addEntryToMetadataBuilder(ImmutableMetadata.ImmutableMetadataBuilder metadataBuilder, String key, Object value) {
        if (value instanceof Number) {
            if (value instanceof Long) {
                metadataBuilder.addLong(key, (Long)value);
                return;
            }
            if (value instanceof Double) {
                metadataBuilder.addDouble(key, (Double)value);
                return;
            }
            if (value instanceof Integer) {
                metadataBuilder.addInteger(key, (Integer)value);
                return;
            }
            if (value instanceof Float) {
                metadataBuilder.addFloat(key, (Float)value);
                return;
            }
        } else {
            if (value instanceof Boolean) {
                metadataBuilder.addBoolean(key, (Boolean)value);
                return;
            }
            if (value instanceof String) {
                metadataBuilder.addString(key, (String)value);
                return;
            }
        }
        throw new IllegalArgumentException("The type of the Metadata entry with key " + key + " and value " + value + " is not supported");
    }
}

