/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.process.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import dev.openfeature.contrib.providers.flagd.resolver.process.model.FeatureFlag;
import dev.openfeature.contrib.providers.flagd.resolver.process.model.ParsingResult;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Feature flag comes as a Json configuration, hence they must be exposed")
public class FlagParser {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlagParser.class);
    private static final String FLAG_KEY = "flags";
    private static final String METADATA_KEY = "metadata";
    private static final String EVALUATOR_KEY = "$evaluators";
    private static final String REPLACER_FORMAT = "\"\\$ref\":(\\s)*\"%s\"";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static JsonSchema SCHEMA_VALIDATOR;

    private FlagParser() {
    }

    public static ParsingResult parseString(String configuration, boolean throwIfInvalid) throws IOException {
        Map<String, Object> flagSetMetadata;
        if (SCHEMA_VALIDATOR != null) {
            try (JsonParser parser = MAPPER.createParser(configuration);){
                Set validationMessages = SCHEMA_VALIDATOR.validate((JsonNode)parser.readValueAsTree());
                if (!validationMessages.isEmpty()) {
                    List distinctMessages = validationMessages.stream().map(ValidationMessage::toString).distinct().collect(Collectors.toList());
                    String message = String.format("Invalid flag configuration: %s", distinctMessages);
                    log.warn(message);
                    if (throwIfInvalid) {
                        throw new IllegalArgumentException(message);
                    }
                }
            }
        }
        String transposedConfiguration = FlagParser.transposeEvaluators(configuration);
        HashMap<String, FeatureFlag> flagMap = new HashMap<String, FeatureFlag>();
        try (JsonParser parser = MAPPER.createParser(transposedConfiguration);){
            TreeNode treeNode = parser.readValueAsTree();
            TreeNode flagNode = treeNode.get(FLAG_KEY);
            TreeNode metadataNode = treeNode.get(METADATA_KEY);
            flagSetMetadata = FlagParser.parseMetadata(metadataNode);
            if (flagNode == null) {
                throw new IllegalArgumentException("No flag configurations found in the payload");
            }
            Iterator it = flagNode.fieldNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                flagMap.put(key, (FeatureFlag)MAPPER.treeToValue(flagNode.get(key), FeatureFlag.class));
            }
        }
        return new ParsingResult(flagMap, flagSetMetadata);
    }

    private static Map<String, Object> parseMetadata(TreeNode metadataNode) throws JsonProcessingException {
        if (metadataNode == null) {
            return new HashMap<String, Object>();
        }
        TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
        return (Map)MAPPER.treeToValue(metadataNode, (TypeReference)typeRef);
    }

    private static String transposeEvaluators(String configuration) throws IOException {
        try (JsonParser parser = MAPPER.createParser(configuration);){
            HashMap<String, Pattern> patternMap = new HashMap<String, Pattern>();
            TreeNode treeNode = parser.readValueAsTree();
            TreeNode evaluators = treeNode.get(EVALUATOR_KEY);
            if (evaluators == null || evaluators.size() == 0) {
                String string = configuration;
                return string;
            }
            String replacedConfigurations = configuration;
            Iterator evalFields = evaluators.fieldNames();
            while (evalFields.hasNext()) {
                String evalName = (String)evalFields.next();
                String evaluator = evaluators.get(evalName).toString();
                String replacer = evaluator.substring(1, evaluator.length() - 1);
                String replacePattern = String.format(REPLACER_FORMAT, evalName);
                Pattern reg_replace = patternMap.computeIfAbsent(replacePattern, s -> Pattern.compile(replacePattern));
                replacedConfigurations = reg_replace.matcher(replacedConfigurations).replaceAll(replacer);
            }
            String string = replacedConfigurations;
            return string;
        }
    }

    static {
        try {
            HashMap<String, String> mappings = new HashMap<String, String>();
            mappings.put("https://flagd.dev/schema/v0/targeting.json", "classpath:flagd/schemas/targeting.json");
            mappings.put("https://flagd.dev/schema/v0/flags.json", "classpath:flagd/schemas/flags.json");
            SCHEMA_VALIDATOR = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7, builder -> builder.schemaMappers(schemaMappers -> schemaMappers.mappings(mappings))).getSchema(new URI("https://flagd.dev/schema/v0/flags.json"));
        }
        catch (Throwable e) {
            log.warn(String.format("Error loading schema resources, schema validation will be skipped", new Object[0]));
        }
    }
}

