/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.rpc;

import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import dev.openfeature.contrib.providers.flagd.FlagdOptions;
import dev.openfeature.contrib.providers.flagd.resolver.Resolver;
import dev.openfeature.contrib.providers.flagd.resolver.common.ChannelConnector;
import dev.openfeature.contrib.providers.flagd.resolver.common.FlagdProviderEvent;
import dev.openfeature.contrib.providers.flagd.resolver.common.QueueingStreamObserver;
import dev.openfeature.contrib.providers.flagd.resolver.common.StreamResponseModel;
import dev.openfeature.contrib.providers.flagd.resolver.rpc.Convert;
import dev.openfeature.contrib.providers.flagd.resolver.rpc.cache.Cache;
import dev.openfeature.contrib.providers.flagd.resolver.rpc.strategy.ResolveFactory;
import dev.openfeature.contrib.providers.flagd.resolver.rpc.strategy.ResolveStrategy;
import dev.openfeature.flagd.grpc.evaluation.Evaluation;
import dev.openfeature.flagd.grpc.evaluation.ServiceGrpc;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.ImmutableMetadata;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.ProviderEvent;
import dev.openfeature.sdk.Value;
import dev.openfeature.sdk.exceptions.FlagNotFoundError;
import dev.openfeature.sdk.exceptions.GeneralError;
import dev.openfeature.sdk.exceptions.OpenFeatureError;
import dev.openfeature.sdk.exceptions.ParseError;
import dev.openfeature.sdk.exceptions.TypeMismatchError;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.Channel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(justification="cache needs to be read and write by multiple objects")
public final class RpcResolver
implements Resolver {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RpcResolver.class);
    private static final int QUEUE_SIZE = 5;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final ChannelConnector<ServiceGrpc.ServiceStub, ServiceGrpc.ServiceBlockingStub> connector;
    private final Cache cache;
    private final ResolveStrategy strategy;
    private final FlagdOptions options;
    private final LinkedBlockingQueue<StreamResponseModel<Evaluation.EventStreamResponse>> incomingQueue;
    private final Consumer<FlagdProviderEvent> onProviderEvent;
    private final ServiceGrpc.ServiceStub stub;
    private final ServiceGrpc.ServiceBlockingStub blockingStub;

    public RpcResolver(FlagdOptions options, Cache cache, Consumer<FlagdProviderEvent> onProviderEvent) {
        this.cache = cache;
        this.strategy = ResolveFactory.getStrategy(options);
        this.options = options;
        this.incomingQueue = new LinkedBlockingQueue(5);
        this.connector = new ChannelConnector(options, onProviderEvent);
        this.onProviderEvent = onProviderEvent;
        this.stub = (ServiceGrpc.ServiceStub)ServiceGrpc.newStub((Channel)this.connector.getChannel()).withWaitForReady();
        this.blockingStub = (ServiceGrpc.ServiceBlockingStub)ServiceGrpc.newBlockingStub((Channel)this.connector.getChannel()).withWaitForReady();
    }

    protected RpcResolver(FlagdOptions options, Cache cache, Consumer<FlagdProviderEvent> onProviderEvent, ServiceGrpc.ServiceStub mockStub, ServiceGrpc.ServiceBlockingStub mockBlockingStub, ChannelConnector<ServiceGrpc.ServiceStub, ServiceGrpc.ServiceBlockingStub> connector) {
        this.cache = cache;
        this.strategy = ResolveFactory.getStrategy(options);
        this.options = options;
        this.incomingQueue = new LinkedBlockingQueue(5);
        this.connector = connector;
        this.onProviderEvent = onProviderEvent;
        this.stub = mockStub;
        this.blockingStub = mockBlockingStub;
    }

    @Override
    public void init() throws Exception {
        this.connector.initialize();
        Thread listener = new Thread(() -> {
            try {
                this.observeEventStream();
            }
            catch (InterruptedException e) {
                log.warn("gRPC event stream interrupted, flag configurations are stale", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        });
        listener.setDaemon(true);
        listener.start();
    }

    @Override
    public void shutdown() throws Exception {
        if (this.shutdown.getAndSet(true)) {
            return;
        }
        this.connector.shutdown();
    }

    @Override
    public void onError() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Override
    public ProviderEvaluation<Boolean> booleanEvaluation(String key, Boolean defaultValue, EvaluationContext ctx) {
        Evaluation.ResolveBooleanRequest request = Evaluation.ResolveBooleanRequest.newBuilder().buildPartial();
        return this.resolve(key, ctx, request, this.getBlockingStub()::resolveBoolean, null);
    }

    @Override
    public ProviderEvaluation<String> stringEvaluation(String key, String defaultValue, EvaluationContext ctx) {
        Evaluation.ResolveStringRequest request = Evaluation.ResolveStringRequest.newBuilder().buildPartial();
        return this.resolve(key, ctx, request, this.getBlockingStub()::resolveString, null);
    }

    @Override
    public ProviderEvaluation<Double> doubleEvaluation(String key, Double defaultValue, EvaluationContext ctx) {
        Evaluation.ResolveFloatRequest request = Evaluation.ResolveFloatRequest.newBuilder().buildPartial();
        return this.resolve(key, ctx, request, this.getBlockingStub()::resolveFloat, null);
    }

    @Override
    public ProviderEvaluation<Integer> integerEvaluation(String key, Integer defaultValue, EvaluationContext ctx) {
        Evaluation.ResolveIntRequest request = Evaluation.ResolveIntRequest.newBuilder().buildPartial();
        return this.resolve(key, ctx, request, this.getBlockingStub()::resolveInt, value -> ((Long)value).intValue());
    }

    private ServiceGrpc.ServiceBlockingStub getBlockingStub() {
        ServiceGrpc.ServiceBlockingStub localStub = this.blockingStub;
        if (this.options.getDeadline() > 0) {
            localStub = (ServiceGrpc.ServiceBlockingStub)localStub.withDeadlineAfter(this.options.getDeadline(), TimeUnit.MILLISECONDS);
        }
        return localStub;
    }

    @Override
    public ProviderEvaluation<Value> objectEvaluation(String key, Value defaultValue, EvaluationContext ctx) {
        Evaluation.ResolveObjectRequest request = Evaluation.ResolveObjectRequest.newBuilder().buildPartial();
        return this.resolve(key, ctx, request, this.getBlockingStub()::resolveObject, value -> dev.openfeature.contrib.providers.flagd.resolver.common.Convert.convertObjectResponse((Struct)value));
    }

    private <ValT, ReqT extends Message, ResT extends Message> ProviderEvaluation<ValT> resolve(String key, EvaluationContext ctx, ReqT request, Function<ReqT, ResT> resolverRef, Convert<ValT, Object> converter) {
        ResT response;
        ProviderEvaluation<?> fromCache;
        if (this.cacheAvailable().booleanValue() && (fromCache = this.cache.get(key)) != null) {
            fromCache.setReason("CACHED");
            return fromCache;
        }
        Message req = request.newBuilderForType().setField(dev.openfeature.contrib.providers.flagd.resolver.common.Convert.getFieldDescriptor(request, "flag_key"), (Object)key).setField(dev.openfeature.contrib.providers.flagd.resolver.common.Convert.getFieldDescriptor(request, "context"), (Object)dev.openfeature.contrib.providers.flagd.resolver.common.Convert.convertContext(ctx)).build();
        try {
            response = this.strategy.resolve(resolverRef, req, key);
        }
        catch (Exception e) {
            OpenFeatureError openFeatureError = this.mapError(e);
            throw openFeatureError;
        }
        Object value = converter == null ? dev.openfeature.contrib.providers.flagd.resolver.common.Convert.getField(response, "value") : converter.convert(dev.openfeature.contrib.providers.flagd.resolver.common.Convert.getField(response, "value"));
        ImmutableMetadata immutableMetadata = RpcResolver.metadataFromResponse(response);
        ProviderEvaluation result = ProviderEvaluation.builder().value(value).variant((String)dev.openfeature.contrib.providers.flagd.resolver.common.Convert.getField(response, "variant")).reason((String)dev.openfeature.contrib.providers.flagd.resolver.common.Convert.getField(response, "reason")).flagMetadata(immutableMetadata).build();
        if (this.isEvaluationCacheable(result).booleanValue()) {
            this.cache.put(key, result);
        }
        return result;
    }

    private <T> Boolean isEvaluationCacheable(ProviderEvaluation<T> evaluation) {
        String reason = evaluation.getReason();
        return reason != null && reason.equals("STATIC") && this.cacheAvailable() != false;
    }

    private Boolean cacheAvailable() {
        return this.cache.getEnabled();
    }

    private static ImmutableMetadata metadataFromResponse(Message response) {
        Object metadata = response.getField(dev.openfeature.contrib.providers.flagd.resolver.common.Convert.getFieldDescriptor(response, "metadata"));
        if (!(metadata instanceof Struct)) {
            return ImmutableMetadata.builder().build();
        }
        Struct struct = (Struct)metadata;
        ImmutableMetadata.ImmutableMetadataBuilder builder = ImmutableMetadata.builder();
        for (Map.Entry entry : struct.getFieldsMap().entrySet()) {
            if (((com.google.protobuf.Value)entry.getValue()).hasStringValue()) {
                builder.addString((String)entry.getKey(), ((com.google.protobuf.Value)entry.getValue()).getStringValue());
                continue;
            }
            if (((com.google.protobuf.Value)entry.getValue()).hasBoolValue()) {
                builder.addBoolean((String)entry.getKey(), Boolean.valueOf(((com.google.protobuf.Value)entry.getValue()).getBoolValue()));
                continue;
            }
            if (!((com.google.protobuf.Value)entry.getValue()).hasNumberValue()) continue;
            builder.addDouble((String)entry.getKey(), Double.valueOf(((com.google.protobuf.Value)entry.getValue()).getNumberValue()));
        }
        return builder.build();
    }

    private OpenFeatureError mapError(Exception e) {
        if (e instanceof StatusRuntimeException) {
            Status.Code code = ((StatusRuntimeException)e).getStatus().getCode();
            switch (code) {
                case DATA_LOSS: {
                    return new ParseError(e.getMessage());
                }
                case INVALID_ARGUMENT: {
                    return new TypeMismatchError(e.getMessage());
                }
                case NOT_FOUND: {
                    return new FlagNotFoundError(e.getMessage());
                }
            }
            return new GeneralError(e.getMessage());
        }
        return new GeneralError(e.getMessage());
    }

    private void restartStream() {
        ServiceGrpc.ServiceStub localStub = this.stub;
        if (this.options.getStreamDeadlineMs() > 0) {
            localStub = (ServiceGrpc.ServiceStub)localStub.withDeadlineAfter(this.options.getStreamDeadlineMs(), TimeUnit.MILLISECONDS);
        }
        localStub.eventStream(Evaluation.EventStreamRequest.getDefaultInstance(), new QueueingStreamObserver<Evaluation.EventStreamResponse>(this.incomingQueue));
    }

    private void observeEventStream() throws InterruptedException {
        log.info("Initializing event stream observer");
        block8: while (!this.shutdown.get()) {
            log.debug("Initializing event stream request");
            this.restartStream();
            block9: while (!this.shutdown.get()) {
                StreamResponseModel<Evaluation.EventStreamResponse> taken = this.incomingQueue.take();
                if (taken.isComplete()) {
                    log.debug("Event stream completed, will reconnect");
                    this.handleErrorOrComplete();
                    continue block8;
                }
                Throwable streamException = taken.getError();
                if (streamException != null) {
                    log.debug("Exception in event stream connection, streamException {}, will reconnect", streamException);
                    this.handleErrorOrComplete();
                    continue block8;
                }
                Evaluation.EventStreamResponse response = taken.getResponse();
                log.debug("Got stream response: {}", (Object)response);
                switch (response.getType()) {
                    case "configuration_change": {
                        this.handleConfigurationChangeEvent(response);
                        continue block9;
                    }
                    case "provider_ready": {
                        this.handleProviderReadyEvent();
                        continue block9;
                    }
                }
                log.debug("Unhandled event type {}", (Object)response.getType());
            }
        }
        log.info("Shutdown invoked, exiting event stream listener");
    }

    private void handleConfigurationChangeEvent(Evaluation.EventStreamResponse value) {
        ArrayList<String> changedFlags = new ArrayList<String>();
        Map data = value.getData().getFieldsMap();
        com.google.protobuf.Value flagsValue = (com.google.protobuf.Value)data.get("flags");
        if (flagsValue != null) {
            Map flags = flagsValue.getStructValue().getFieldsMap();
            changedFlags.addAll(flags.keySet());
        }
        log.debug("Emitting provider change event");
        if (this.cache != null) {
            changedFlags.forEach(this.cache::remove);
        }
        this.onProviderEvent.accept(new FlagdProviderEvent(ProviderEvent.PROVIDER_CONFIGURATION_CHANGED, changedFlags));
    }

    private void handleProviderReadyEvent() {
        log.debug("Emitting provider ready event");
        this.onProviderEvent.accept(new FlagdProviderEvent(ProviderEvent.PROVIDER_READY));
    }

    private void handleErrorOrComplete() {
        log.debug("Emitting provider error event");
        this.onProviderEvent.accept(new FlagdProviderEvent(ProviderEvent.PROVIDER_ERROR));
    }
}

