/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd;

import dev.openfeature.contrib.providers.flagd.Config;
import io.opentelemetry.api.OpenTelemetry;

public class FlagdOptions {
    private String host;
    private int port;
    private boolean tls;
    private String certPath;
    private String socketPath;
    private String cacheType;
    private int maxCacheSize;
    private int maxEventStreamRetries;
    private OpenTelemetry openTelemetry;

    private static String $default$host() {
        return Config.fallBackToEnvOrDefault("FLAGD_HOST", "localhost");
    }

    private static int $default$port() {
        return Integer.parseInt(Config.fallBackToEnvOrDefault("FLAGD_PORT", "8013"));
    }

    private static boolean $default$tls() {
        return Boolean.parseBoolean(Config.fallBackToEnvOrDefault("FLAGD_TLS", "false"));
    }

    private static String $default$certPath() {
        return Config.fallBackToEnvOrDefault("FLAGD_SERVER_CERT_PATH", null);
    }

    private static String $default$socketPath() {
        return Config.fallBackToEnvOrDefault("FLAGD_SOCKET_PATH", null);
    }

    private static String $default$cacheType() {
        return Config.fallBackToEnvOrDefault("FLAGD_CACHE", "lru");
    }

    private static int $default$maxCacheSize() {
        return Config.fallBackToEnvOrDefault("FLAGD_MAX_CACHE_SIZE", 1000);
    }

    private static int $default$maxEventStreamRetries() {
        return Config.fallBackToEnvOrDefault("FLAGD_MAX_EVENT_STREAM_RETRIES", 5);
    }

    FlagdOptions(String host, int port, boolean tls, String certPath, String socketPath, String cacheType, int maxCacheSize, int maxEventStreamRetries, OpenTelemetry openTelemetry) {
        this.host = host;
        this.port = port;
        this.tls = tls;
        this.certPath = certPath;
        this.socketPath = socketPath;
        this.cacheType = cacheType;
        this.maxCacheSize = maxCacheSize;
        this.maxEventStreamRetries = maxEventStreamRetries;
        this.openTelemetry = openTelemetry;
    }

    public static FlagdOptionsBuilder builder() {
        return new FlagdOptionsBuilder();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isTls() {
        return this.tls;
    }

    public String getCertPath() {
        return this.certPath;
    }

    public String getSocketPath() {
        return this.socketPath;
    }

    public String getCacheType() {
        return this.cacheType;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public int getMaxEventStreamRetries() {
        return this.maxEventStreamRetries;
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    public static class FlagdOptionsBuilder {
        private boolean host$set;
        private String host$value;
        private boolean port$set;
        private int port$value;
        private boolean tls$set;
        private boolean tls$value;
        private boolean certPath$set;
        private String certPath$value;
        private boolean socketPath$set;
        private String socketPath$value;
        private boolean cacheType$set;
        private String cacheType$value;
        private boolean maxCacheSize$set;
        private int maxCacheSize$value;
        private boolean maxEventStreamRetries$set;
        private int maxEventStreamRetries$value;
        private OpenTelemetry openTelemetry;

        FlagdOptionsBuilder() {
        }

        public FlagdOptionsBuilder host(String host) {
            this.host$value = host;
            this.host$set = true;
            return this;
        }

        public FlagdOptionsBuilder port(int port) {
            this.port$value = port;
            this.port$set = true;
            return this;
        }

        public FlagdOptionsBuilder tls(boolean tls) {
            this.tls$value = tls;
            this.tls$set = true;
            return this;
        }

        public FlagdOptionsBuilder certPath(String certPath) {
            this.certPath$value = certPath;
            this.certPath$set = true;
            return this;
        }

        public FlagdOptionsBuilder socketPath(String socketPath) {
            this.socketPath$value = socketPath;
            this.socketPath$set = true;
            return this;
        }

        public FlagdOptionsBuilder cacheType(String cacheType) {
            this.cacheType$value = cacheType;
            this.cacheType$set = true;
            return this;
        }

        public FlagdOptionsBuilder maxCacheSize(int maxCacheSize) {
            this.maxCacheSize$value = maxCacheSize;
            this.maxCacheSize$set = true;
            return this;
        }

        public FlagdOptionsBuilder maxEventStreamRetries(int maxEventStreamRetries) {
            this.maxEventStreamRetries$value = maxEventStreamRetries;
            this.maxEventStreamRetries$set = true;
            return this;
        }

        public FlagdOptionsBuilder openTelemetry(OpenTelemetry openTelemetry) {
            this.openTelemetry = openTelemetry;
            return this;
        }

        public FlagdOptions build() {
            String host$value = this.host$value;
            if (!this.host$set) {
                host$value = FlagdOptions.$default$host();
            }
            int port$value = this.port$value;
            if (!this.port$set) {
                port$value = FlagdOptions.$default$port();
            }
            boolean tls$value = this.tls$value;
            if (!this.tls$set) {
                tls$value = FlagdOptions.$default$tls();
            }
            String certPath$value = this.certPath$value;
            if (!this.certPath$set) {
                certPath$value = FlagdOptions.$default$certPath();
            }
            String socketPath$value = this.socketPath$value;
            if (!this.socketPath$set) {
                socketPath$value = FlagdOptions.$default$socketPath();
            }
            String cacheType$value = this.cacheType$value;
            if (!this.cacheType$set) {
                cacheType$value = FlagdOptions.$default$cacheType();
            }
            int maxCacheSize$value = this.maxCacheSize$value;
            if (!this.maxCacheSize$set) {
                maxCacheSize$value = FlagdOptions.$default$maxCacheSize();
            }
            int maxEventStreamRetries$value = this.maxEventStreamRetries$value;
            if (!this.maxEventStreamRetries$set) {
                maxEventStreamRetries$value = FlagdOptions.$default$maxEventStreamRetries();
            }
            return new FlagdOptions(host$value, port$value, tls$value, certPath$value, socketPath$value, cacheType$value, maxCacheSize$value, maxEventStreamRetries$value, this.openTelemetry);
        }

        public String toString() {
            return "FlagdOptions.FlagdOptionsBuilder(host$value=" + this.host$value + ", port$value=" + this.port$value + ", tls$value=" + this.tls$value + ", certPath$value=" + this.certPath$value + ", socketPath$value=" + this.socketPath$value + ", cacheType$value=" + this.cacheType$value + ", maxCacheSize$value=" + this.maxCacheSize$value + ", maxEventStreamRetries$value=" + this.maxEventStreamRetries$value + ", openTelemetry=" + this.openTelemetry + ")";
        }
    }
}

