/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd;

import com.google.protobuf.ListValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import dev.openfeature.contrib.providers.flagd.SslConfigException;
import dev.openfeature.flagd.grpc.Schema;
import dev.openfeature.flagd.grpc.ServiceGrpc;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.FeatureProvider;
import dev.openfeature.sdk.Metadata;
import dev.openfeature.sdk.MutableStructure;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.Structure;
import dev.openfeature.sdk.Value;
import io.grpc.Channel;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlagdProvider
implements FeatureProvider {
    private static final Logger log = LoggerFactory.getLogger(FlagdProvider.class);
    static final String PROVIDER_NAME = "flagD Provider";
    static final String DEFAULT_PORT = "8013";
    static final String DEFAULT_TLS = "false";
    static final String DEFAULT_HOST = "localhost";
    static final int DEFAULT_DEADLINE = 500;
    static final String HOST_ENV_VAR_NAME = "FLAGD_HOST";
    static final String PORT_ENV_VAR_NAME = "FLAGD_PORT";
    static final String TLS_ENV_VAR_NAME = "FLAGD_TLS";
    static final String SOCKET_PATH_ENV_VAR_NAME = "FLAGD_SOCKET_PATH";
    static final String SERVER_CERT_PATH_ENV_VAR_NAME = "FLAGD_SERVER_CERT_PATH";
    private long deadline = 500L;
    private ServiceGrpc.ServiceBlockingStub serviceStub;

    public FlagdProvider(String socketPath) {
        this(FlagdProvider.buildServiceStub(null, null, null, null, socketPath));
    }

    public FlagdProvider(String host, int port, boolean tls, String certPath) {
        this(FlagdProvider.buildServiceStub(host, port, tls, certPath, null));
    }

    public FlagdProvider() {
        this(FlagdProvider.buildServiceStub(null, null, null, null, null));
    }

    FlagdProvider(ServiceGrpc.ServiceBlockingStub serviceStub) {
        this.serviceStub = serviceStub;
    }

    public Metadata getMetadata() {
        return new Metadata(){

            public String getName() {
                return FlagdProvider.PROVIDER_NAME;
            }
        };
    }

    public ProviderEvaluation<Boolean> getBooleanEvaluation(String key, Boolean defaultValue, EvaluationContext ctx) {
        Schema.ResolveBooleanRequest request = Schema.ResolveBooleanRequest.newBuilder().setFlagKey(key).setContext(this.convertContext(ctx)).build();
        Schema.ResolveBooleanResponse r = ((ServiceGrpc.ServiceBlockingStub)this.serviceStub.withDeadlineAfter(this.deadline, TimeUnit.MILLISECONDS)).resolveBoolean(request);
        return ProviderEvaluation.builder().value((Object)r.getValue()).variant(r.getVariant()).reason(r.getReason()).build();
    }

    public ProviderEvaluation<String> getStringEvaluation(String key, String defaultValue, EvaluationContext ctx) {
        Schema.ResolveStringRequest request = Schema.ResolveStringRequest.newBuilder().setFlagKey(key).setContext(this.convertContext(ctx)).build();
        Schema.ResolveStringResponse r = ((ServiceGrpc.ServiceBlockingStub)this.serviceStub.withDeadlineAfter(this.deadline, TimeUnit.MILLISECONDS)).resolveString(request);
        return ProviderEvaluation.builder().value((Object)r.getValue()).variant(r.getVariant()).reason(r.getReason()).build();
    }

    public ProviderEvaluation<Double> getDoubleEvaluation(String key, Double defaultValue, EvaluationContext ctx) {
        Schema.ResolveFloatRequest request = Schema.ResolveFloatRequest.newBuilder().setFlagKey(key).setContext(this.convertContext(ctx)).build();
        Schema.ResolveFloatResponse r = ((ServiceGrpc.ServiceBlockingStub)this.serviceStub.withDeadlineAfter(this.deadline, TimeUnit.MILLISECONDS)).resolveFloat(request);
        return ProviderEvaluation.builder().value((Object)r.getValue()).variant(r.getVariant()).reason(r.getReason()).build();
    }

    public ProviderEvaluation<Integer> getIntegerEvaluation(String key, Integer defaultValue, EvaluationContext ctx) {
        Schema.ResolveIntRequest request = Schema.ResolveIntRequest.newBuilder().setFlagKey(key).setContext(this.convertContext(ctx)).build();
        Schema.ResolveIntResponse r = ((ServiceGrpc.ServiceBlockingStub)this.serviceStub.withDeadlineAfter(this.deadline, TimeUnit.MILLISECONDS)).resolveInt(request);
        return ProviderEvaluation.builder().value((Object)((int)r.getValue())).variant(r.getVariant()).reason(r.getReason()).build();
    }

    public ProviderEvaluation<Value> getObjectEvaluation(String key, Value defaultValue, EvaluationContext ctx) {
        Schema.ResolveObjectRequest request = Schema.ResolveObjectRequest.newBuilder().setFlagKey(key).setContext(this.convertContext(ctx)).build();
        Schema.ResolveObjectResponse r = ((ServiceGrpc.ServiceBlockingStub)this.serviceStub.withDeadlineAfter(this.deadline, TimeUnit.MILLISECONDS)).resolveObject(request);
        return ProviderEvaluation.builder().value((Object)this.convertObjectResponse(r.getValue())).variant(r.getVariant()).reason(r.getReason()).build();
    }

    public FlagdProvider setDeadline(long deadlineMs) {
        this.deadline = deadlineMs;
        return this;
    }

    private Value convertObjectResponse(Struct protobuf) {
        return this.convertProtobufMap(protobuf.getFieldsMap());
    }

    private Struct convertContext(EvaluationContext ctx) {
        return this.convertMap(ctx.asMap()).getStructValue();
    }

    private com.google.protobuf.Value convertAny(Value value) {
        if (value.isList()) {
            return this.convertList(value.asList());
        }
        if (value.isStructure()) {
            return this.convertMap(value.asStructure().asMap());
        }
        return this.convertPrimitive(value);
    }

    private Value convertAny(com.google.protobuf.Value protobuf) {
        if (protobuf.hasListValue()) {
            return this.convertList(protobuf.getListValue());
        }
        if (protobuf.hasStructValue()) {
            return this.convertProtobufMap(protobuf.getStructValue().getFieldsMap());
        }
        return this.convertPrimitive(protobuf);
    }

    private com.google.protobuf.Value convertMap(Map<String, Value> map) {
        HashMap values = new HashMap();
        map.keySet().stream().forEach(key -> {
            Value value = (Value)map.get(key);
            values.put(key, this.convertAny(value));
        });
        Struct struct = Struct.newBuilder().putAllFields(values).build();
        return com.google.protobuf.Value.newBuilder().setStructValue(struct).build();
    }

    private Value convertProtobufMap(Map<String, com.google.protobuf.Value> map) {
        HashMap values = new HashMap();
        map.keySet().stream().forEach(key -> {
            com.google.protobuf.Value value = (com.google.protobuf.Value)map.get(key);
            values.put(key, this.convertAny(value));
        });
        return new Value((Structure)new MutableStructure(values));
    }

    private com.google.protobuf.Value convertList(List<Value> values) {
        ListValue list = ListValue.newBuilder().addAllValues((Iterable)values.stream().map(v -> this.convertAny((Value)v)).collect(Collectors.toList())).build();
        return com.google.protobuf.Value.newBuilder().setListValue(list).build();
    }

    private Value convertList(ListValue protobuf) {
        return new Value(protobuf.getValuesList().stream().map(p -> this.convertAny((com.google.protobuf.Value)p)).collect(Collectors.toList()));
    }

    private com.google.protobuf.Value convertPrimitive(Value value) {
        Value.Builder builder = com.google.protobuf.Value.newBuilder();
        if (value.isBoolean()) {
            builder.setBoolValue(value.asBoolean().booleanValue());
        } else if (value.isString()) {
            builder.setStringValue(value.asString());
        } else if (value.isNumber()) {
            builder.setNumberValue(value.asDouble().doubleValue());
        } else {
            builder.setNullValue(null);
        }
        return builder.build();
    }

    private Value convertPrimitive(com.google.protobuf.Value protobuf) {
        Value value = protobuf.hasBoolValue() ? new Value(Boolean.valueOf(protobuf.getBoolValue())) : (protobuf.hasStringValue() ? new Value(protobuf.getStringValue()) : (protobuf.hasNumberValue() ? new Value(Double.valueOf(protobuf.getNumberValue())) : new Value()));
        return value;
    }

    private static ServiceGrpc.ServiceBlockingStub buildServiceStub(String host, Integer port, Boolean tls, String certPath, String socketPath) {
        host = host != null ? host : FlagdProvider.fallBackToEnvOrDefault(HOST_ENV_VAR_NAME, DEFAULT_HOST);
        port = port != null ? port : Integer.parseInt(FlagdProvider.fallBackToEnvOrDefault(PORT_ENV_VAR_NAME, DEFAULT_PORT));
        tls = tls != null ? tls : Boolean.parseBoolean(FlagdProvider.fallBackToEnvOrDefault(TLS_ENV_VAR_NAME, DEFAULT_TLS));
        certPath = certPath != null ? certPath : FlagdProvider.fallBackToEnvOrDefault(SERVER_CERT_PATH_ENV_VAR_NAME, null);
        String string = socketPath = socketPath != null ? socketPath : FlagdProvider.fallBackToEnvOrDefault(SOCKET_PATH_ENV_VAR_NAME, null);
        if (socketPath != null) {
            return ServiceGrpc.newBlockingStub((Channel)NettyChannelBuilder.forAddress((SocketAddress)new DomainSocketAddress(socketPath)).eventLoopGroup((EventLoopGroup)new EpollEventLoopGroup()).channelType(EpollDomainSocketChannel.class).usePlaintext().build());
        }
        try {
            NettyChannelBuilder builder = NettyChannelBuilder.forAddress((String)host, (int)port);
            if (tls.booleanValue()) {
                SslContextBuilder sslContext = GrpcSslContexts.forClient();
                if (certPath != null) {
                    sslContext.trustManager(new File(certPath));
                }
                builder.sslContext(sslContext.build());
            } else {
                builder.usePlaintext();
            }
            return ServiceGrpc.newBlockingStub((Channel)builder.build());
        }
        catch (SSLException ssle) {
            SslConfigException sslConfigException = new SslConfigException("Error with SSL configuration.");
            sslConfigException.initCause(ssle);
            throw sslConfigException;
        }
    }

    private static String fallBackToEnvOrDefault(String key, String defaultValue) {
        return System.getenv(key) != null ? System.getenv(key) : defaultValue;
    }
}

