/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd;

import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.Value;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;

public class FlagdCache {
    private Map<String, ProviderEvaluation<Value>> store;
    private Boolean enabled = false;
    static final String LRU_CACHE = "lru";
    static final String DISABLED = "disabled";

    FlagdCache(String cache, int maxCacheSize) {
        if (cache == null) {
            return;
        }
        switch (cache) {
            case "disabled": {
                return;
            }
        }
        this.store = Collections.synchronizedMap(new LRUMap(maxCacheSize));
        this.enabled = true;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void put(String key, ProviderEvaluation<Value> value) {
        this.store.put(key, value);
    }

    public ProviderEvaluation<Value> get(String key) {
        return this.store.get(key);
    }

    public void remove(String key) {
        this.store.remove(key);
    }

    public void clear() {
        this.store.clear();
    }
}

