/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd;

import com.google.protobuf.ListValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import dev.openfeature.contrib.providers.flagd.EventStreamCallback;
import dev.openfeature.contrib.providers.flagd.EventStreamObserver;
import dev.openfeature.contrib.providers.flagd.FlagdCache;
import dev.openfeature.contrib.providers.flagd.SslConfigException;
import dev.openfeature.flagd.grpc.Schema;
import dev.openfeature.flagd.grpc.ServiceGrpc;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.FeatureProvider;
import dev.openfeature.sdk.Metadata;
import dev.openfeature.sdk.MutableStructure;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.Structure;
import dev.openfeature.sdk.Value;
import io.grpc.Channel;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlagdProvider
implements FeatureProvider,
EventStreamCallback {
    private static final Logger log = LoggerFactory.getLogger(FlagdProvider.class);
    static final String PROVIDER_NAME = "flagD Provider";
    static final String DEFAULT_PORT = "8013";
    static final String DEFAULT_TLS = "false";
    static final String DEFAULT_HOST = "localhost";
    static final int DEFAULT_DEADLINE = 500;
    static final String HOST_ENV_VAR_NAME = "FLAGD_HOST";
    static final String PORT_ENV_VAR_NAME = "FLAGD_PORT";
    static final String TLS_ENV_VAR_NAME = "FLAGD_TLS";
    static final String SOCKET_PATH_ENV_VAR_NAME = "FLAGD_SOCKET_PATH";
    static final String SERVER_CERT_PATH_ENV_VAR_NAME = "FLAGD_SERVER_CERT_PATH";
    static final String CACHE_ENV_VAR_NAME = "FLAGD_CACHE";
    static final String MAX_CACHE_SIZE_ENV_VAR_NAME = "FLAGD_MAX_CACHE_SIZE";
    static final String MAX_EVENT_STREAM_RETRIES_ENV_VAR_NAME = "FLAGD_MAX_EVENT_STREAM_RETRIES";
    static final String STATIC_REASON = "STATIC";
    static final String CACHED_REASON = "CACHED";
    static final String LRU_CACHE = "lru";
    static final String DISABLED = "disabled";
    static final String DEFAULT_CACHE = "lru";
    static final int DEFAULT_MAX_CACHE_SIZE = 1000;
    static final int DEFAULT_MAX_EVENT_STREAM_RETRIES = 5;
    static final int BASE_EVENT_STREAM_RETRY_BACKOFF_MS = 1000;
    private long deadline = 500L;
    private ServiceGrpc.ServiceBlockingStub serviceBlockingStub;
    private ServiceGrpc.ServiceStub serviceStub;
    private Boolean eventStreamAlive;
    private FlagdCache cache;
    private int eventStreamAttempt = 1;
    private int eventStreamRetryBackoff = 1000;
    private int maxEventStreamRetries = 5;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Object eventStreamAliveSync;

    public FlagdProvider(String socketPath) {
        this(FlagdProvider.buildServiceBlockingStub(null, null, null, null, socketPath), FlagdProvider.buildServiceStub(null, null, null, null, socketPath), FlagdProvider.fallBackToEnvOrDefault(CACHE_ENV_VAR_NAME, "lru"), FlagdProvider.fallBackToEnvOrDefault(MAX_CACHE_SIZE_ENV_VAR_NAME, 1000), FlagdProvider.fallBackToEnvOrDefault(MAX_EVENT_STREAM_RETRIES_ENV_VAR_NAME, 5));
    }

    public FlagdProvider(String socketPath, String cache, int maxCacheSize, int maxEventStreamRetries) {
        this(FlagdProvider.buildServiceBlockingStub(null, null, null, null, socketPath), FlagdProvider.buildServiceStub(null, null, null, null, socketPath), cache, maxCacheSize, maxEventStreamRetries);
    }

    public FlagdProvider(String host, int port, boolean tls, String certPath) {
        this(FlagdProvider.buildServiceBlockingStub(host, port, tls, certPath, null), FlagdProvider.buildServiceStub(host, port, tls, certPath, null), FlagdProvider.fallBackToEnvOrDefault(CACHE_ENV_VAR_NAME, "lru"), FlagdProvider.fallBackToEnvOrDefault(MAX_CACHE_SIZE_ENV_VAR_NAME, 1000), FlagdProvider.fallBackToEnvOrDefault(MAX_EVENT_STREAM_RETRIES_ENV_VAR_NAME, 5));
    }

    public FlagdProvider(String host, int port, boolean tls, String certPath, String cache, int maxCacheSize, int maxEventStreamRetries) {
        this(FlagdProvider.buildServiceBlockingStub(host, port, tls, certPath, null), FlagdProvider.buildServiceStub(host, port, tls, certPath, null), cache, maxCacheSize, maxEventStreamRetries);
    }

    public FlagdProvider() {
        this(FlagdProvider.buildServiceBlockingStub(null, null, null, null, null), FlagdProvider.buildServiceStub(null, null, null, null, null), FlagdProvider.fallBackToEnvOrDefault(CACHE_ENV_VAR_NAME, "lru"), FlagdProvider.fallBackToEnvOrDefault(MAX_CACHE_SIZE_ENV_VAR_NAME, 1000), FlagdProvider.fallBackToEnvOrDefault(MAX_EVENT_STREAM_RETRIES_ENV_VAR_NAME, 5));
    }

    FlagdProvider(ServiceGrpc.ServiceBlockingStub serviceBlockingStub, ServiceGrpc.ServiceStub serviceStub, String cache, int maxCacheSize, int maxEventStreamRetries) {
        this.serviceBlockingStub = serviceBlockingStub;
        this.serviceStub = serviceStub;
        this.eventStreamAlive = false;
        this.cache = new FlagdCache(cache, maxCacheSize);
        this.maxEventStreamRetries = maxEventStreamRetries;
        this.eventStreamAliveSync = new Object();
        this.handleEvents();
    }

    private Boolean cacheAvailable() {
        Lock l = this.lock.readLock();
        l.lock();
        Boolean available = this.cache.getEnabled() != false && this.eventStreamAlive != false;
        l.unlock();
        return available;
    }

    public Metadata getMetadata() {
        return new Metadata(){

            public String getName() {
                return FlagdProvider.PROVIDER_NAME;
            }
        };
    }

    public ProviderEvaluation<Boolean> getBooleanEvaluation(String key, Boolean defaultValue, EvaluationContext ctx) {
        ProviderEvaluation<Value> fromCache;
        if (this.cacheAvailable().booleanValue() && (fromCache = this.cache.get(key)) != null) {
            ProviderEvaluation result = ProviderEvaluation.builder().value((Object)((Value)fromCache.getValue()).asBoolean()).variant(fromCache.getVariant()).reason(CACHED_REASON).build();
            return result;
        }
        Schema.ResolveBooleanRequest request = Schema.ResolveBooleanRequest.newBuilder().setFlagKey(key).setContext(this.convertContext(ctx)).build();
        Schema.ResolveBooleanResponse r = ((ServiceGrpc.ServiceBlockingStub)this.serviceBlockingStub.withDeadlineAfter(this.deadline, TimeUnit.MILLISECONDS)).resolveBoolean(request);
        ProviderEvaluation result = ProviderEvaluation.builder().value((Object)r.getValue()).variant(r.getVariant()).reason(r.getReason()).build();
        if (this.isEvaluationCacheable(result).booleanValue()) {
            ProviderEvaluation value = ProviderEvaluation.builder().value((Object)new Value(Boolean.valueOf(r.getValue()))).variant(r.getVariant()).reason(r.getReason()).build();
            this.cache.put(key, (ProviderEvaluation<Value>)value);
        }
        return result;
    }

    public ProviderEvaluation<String> getStringEvaluation(String key, String defaultValue, EvaluationContext ctx) {
        ProviderEvaluation<Value> fromCache;
        if (this.cacheAvailable().booleanValue() && (fromCache = this.cache.get(key)) != null) {
            ProviderEvaluation result = ProviderEvaluation.builder().value((Object)((Value)fromCache.getValue()).asString()).variant(fromCache.getVariant()).reason(CACHED_REASON).build();
            return result;
        }
        Schema.ResolveStringRequest request = Schema.ResolveStringRequest.newBuilder().setFlagKey(key).setContext(this.convertContext(ctx)).build();
        Schema.ResolveStringResponse r = ((ServiceGrpc.ServiceBlockingStub)this.serviceBlockingStub.withDeadlineAfter(this.deadline, TimeUnit.MILLISECONDS)).resolveString(request);
        ProviderEvaluation result = ProviderEvaluation.builder().value((Object)r.getValue()).variant(r.getVariant()).reason(r.getReason()).build();
        if (this.isEvaluationCacheable(result).booleanValue()) {
            ProviderEvaluation value = ProviderEvaluation.builder().value((Object)new Value(r.getValue())).variant(r.getVariant()).reason(r.getReason()).build();
            this.cache.put(key, (ProviderEvaluation<Value>)value);
        }
        return result;
    }

    public ProviderEvaluation<Double> getDoubleEvaluation(String key, Double defaultValue, EvaluationContext ctx) {
        ProviderEvaluation<Value> fromCache;
        if (this.cacheAvailable().booleanValue() && (fromCache = this.cache.get(key)) != null) {
            ProviderEvaluation result = ProviderEvaluation.builder().value((Object)((Value)fromCache.getValue()).asDouble()).variant(fromCache.getVariant()).reason(CACHED_REASON).build();
            return result;
        }
        Schema.ResolveFloatRequest request = Schema.ResolveFloatRequest.newBuilder().setFlagKey(key).setContext(this.convertContext(ctx)).build();
        Schema.ResolveFloatResponse r = ((ServiceGrpc.ServiceBlockingStub)this.serviceBlockingStub.withDeadlineAfter(this.deadline, TimeUnit.MILLISECONDS)).resolveFloat(request);
        ProviderEvaluation result = ProviderEvaluation.builder().value((Object)r.getValue()).variant(r.getVariant()).reason(r.getReason()).build();
        if (this.isEvaluationCacheable(result).booleanValue()) {
            ProviderEvaluation value = ProviderEvaluation.builder().value((Object)new Value(Double.valueOf(r.getValue()))).variant(r.getVariant()).reason(r.getReason()).build();
            this.cache.put(key, (ProviderEvaluation<Value>)value);
        }
        return result;
    }

    public ProviderEvaluation<Integer> getIntegerEvaluation(String key, Integer defaultValue, EvaluationContext ctx) {
        ProviderEvaluation<Value> fromCache;
        if (this.cacheAvailable().booleanValue() && (fromCache = this.cache.get(key)) != null) {
            ProviderEvaluation result = ProviderEvaluation.builder().value((Object)((Value)fromCache.getValue()).asInteger()).variant(fromCache.getVariant()).reason(CACHED_REASON).build();
            return result;
        }
        Schema.ResolveIntRequest request = Schema.ResolveIntRequest.newBuilder().setFlagKey(key).setContext(this.convertContext(ctx)).build();
        Schema.ResolveIntResponse r = ((ServiceGrpc.ServiceBlockingStub)this.serviceBlockingStub.withDeadlineAfter(this.deadline, TimeUnit.MILLISECONDS)).resolveInt(request);
        ProviderEvaluation result = ProviderEvaluation.builder().value((Object)((int)r.getValue())).variant(r.getVariant()).reason(r.getReason()).build();
        if (this.isEvaluationCacheable(result).booleanValue()) {
            ProviderEvaluation value = ProviderEvaluation.builder().value((Object)new Value((Integer)result.getValue())).variant(r.getVariant()).reason(r.getReason()).build();
            this.cache.put(key, (ProviderEvaluation<Value>)value);
        }
        return result;
    }

    public ProviderEvaluation<Value> getObjectEvaluation(String key, Value defaultValue, EvaluationContext ctx) {
        ProviderEvaluation<Value> fromCache;
        if (this.cacheAvailable().booleanValue() && (fromCache = this.cache.get(key)) != null) {
            fromCache.setReason(CACHED_REASON);
            return fromCache;
        }
        Schema.ResolveObjectRequest request = Schema.ResolveObjectRequest.newBuilder().setFlagKey(key).setContext(this.convertContext(ctx)).build();
        Schema.ResolveObjectResponse r = ((ServiceGrpc.ServiceBlockingStub)this.serviceBlockingStub.withDeadlineAfter(this.deadline, TimeUnit.MILLISECONDS)).resolveObject(request);
        ProviderEvaluation result = ProviderEvaluation.builder().value((Object)this.convertObjectResponse(r.getValue())).variant(r.getVariant()).reason(r.getReason()).build();
        if (this.isEvaluationCacheable(result).booleanValue()) {
            this.cache.put(key, (ProviderEvaluation<Value>)result);
        }
        return result;
    }

    public FlagdProvider setDeadline(long deadlineMs) {
        this.deadline = deadlineMs;
        return this;
    }

    private Value convertObjectResponse(Struct protobuf) {
        return this.convertProtobufMap(protobuf.getFieldsMap());
    }

    private Struct convertContext(EvaluationContext ctx) {
        return this.convertMap(ctx.asMap()).getStructValue();
    }

    private com.google.protobuf.Value convertAny(Value value) {
        if (value.isList()) {
            return this.convertList(value.asList());
        }
        if (value.isStructure()) {
            return this.convertMap(value.asStructure().asMap());
        }
        return this.convertPrimitive(value);
    }

    private Value convertAny(com.google.protobuf.Value protobuf) {
        if (protobuf.hasListValue()) {
            return this.convertList(protobuf.getListValue());
        }
        if (protobuf.hasStructValue()) {
            return this.convertProtobufMap(protobuf.getStructValue().getFieldsMap());
        }
        return this.convertPrimitive(protobuf);
    }

    private com.google.protobuf.Value convertMap(Map<String, Value> map) {
        HashMap values = new HashMap();
        map.keySet().stream().forEach(key -> {
            Value value = (Value)map.get(key);
            values.put(key, this.convertAny(value));
        });
        Struct struct = Struct.newBuilder().putAllFields(values).build();
        return com.google.protobuf.Value.newBuilder().setStructValue(struct).build();
    }

    private Value convertProtobufMap(Map<String, com.google.protobuf.Value> map) {
        HashMap values = new HashMap();
        map.keySet().stream().forEach(key -> {
            com.google.protobuf.Value value = (com.google.protobuf.Value)map.get(key);
            values.put(key, this.convertAny(value));
        });
        return new Value((Structure)new MutableStructure(values));
    }

    private com.google.protobuf.Value convertList(List<Value> values) {
        ListValue list = ListValue.newBuilder().addAllValues((Iterable)values.stream().map(v -> this.convertAny((Value)v)).collect(Collectors.toList())).build();
        return com.google.protobuf.Value.newBuilder().setListValue(list).build();
    }

    private Value convertList(ListValue protobuf) {
        return new Value(protobuf.getValuesList().stream().map(p -> this.convertAny((com.google.protobuf.Value)p)).collect(Collectors.toList()));
    }

    private com.google.protobuf.Value convertPrimitive(Value value) {
        Value.Builder builder = com.google.protobuf.Value.newBuilder();
        if (value.isBoolean()) {
            builder.setBoolValue(value.asBoolean().booleanValue());
        } else if (value.isString()) {
            builder.setStringValue(value.asString());
        } else if (value.isNumber()) {
            builder.setNumberValue(value.asDouble().doubleValue());
        } else {
            builder.setNullValue(null);
        }
        return builder.build();
    }

    private Value convertPrimitive(com.google.protobuf.Value protobuf) {
        Value value = protobuf.hasBoolValue() ? new Value(Boolean.valueOf(protobuf.getBoolValue())) : (protobuf.hasStringValue() ? new Value(protobuf.getStringValue()) : (protobuf.hasNumberValue() ? new Value(Double.valueOf(protobuf.getNumberValue())) : new Value()));
        return value;
    }

    private static NettyChannelBuilder channelBuilder(String host, Integer port, Boolean tls, String certPath, String socketPath) {
        host = host != null ? host : FlagdProvider.fallBackToEnvOrDefault(HOST_ENV_VAR_NAME, DEFAULT_HOST);
        port = port != null ? port : Integer.parseInt(FlagdProvider.fallBackToEnvOrDefault(PORT_ENV_VAR_NAME, DEFAULT_PORT));
        tls = tls != null ? tls : Boolean.parseBoolean(FlagdProvider.fallBackToEnvOrDefault(TLS_ENV_VAR_NAME, DEFAULT_TLS));
        certPath = certPath != null ? certPath : FlagdProvider.fallBackToEnvOrDefault(SERVER_CERT_PATH_ENV_VAR_NAME, null);
        String string = socketPath = socketPath != null ? socketPath : FlagdProvider.fallBackToEnvOrDefault(SOCKET_PATH_ENV_VAR_NAME, null);
        if (socketPath != null) {
            return NettyChannelBuilder.forAddress((SocketAddress)new DomainSocketAddress(socketPath)).eventLoopGroup((EventLoopGroup)new EpollEventLoopGroup()).channelType(EpollDomainSocketChannel.class).usePlaintext();
        }
        try {
            NettyChannelBuilder builder = NettyChannelBuilder.forAddress((String)host, (int)port);
            if (tls.booleanValue()) {
                SslContextBuilder sslContext = GrpcSslContexts.forClient();
                if (certPath != null) {
                    sslContext.trustManager(new File(certPath));
                }
                builder.sslContext(sslContext.build());
            } else {
                builder.usePlaintext();
            }
            return builder;
        }
        catch (SSLException ssle) {
            SslConfigException sslConfigException = new SslConfigException("Error with SSL configuration.");
            sslConfigException.initCause(ssle);
            throw sslConfigException;
        }
    }

    private static ServiceGrpc.ServiceBlockingStub buildServiceBlockingStub(String host, Integer port, Boolean tls, String certPath, String socketPath) {
        return ServiceGrpc.newBlockingStub((Channel)FlagdProvider.channelBuilder(host, port, tls, certPath, socketPath).build());
    }

    private static ServiceGrpc.ServiceStub buildServiceStub(String host, Integer port, Boolean tls, String certPath, String socketPath) {
        return ServiceGrpc.newStub((Channel)FlagdProvider.channelBuilder(host, port, tls, certPath, socketPath).build());
    }

    private static String fallBackToEnvOrDefault(String key, String defaultValue) {
        return System.getenv(key) != null ? System.getenv(key) : defaultValue;
    }

    private static int fallBackToEnvOrDefault(String key, int defaultValue) {
        try {
            int value = System.getenv(key) != null ? Integer.parseInt(System.getenv(key)) : defaultValue;
            return value;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private void handleEvents() {
        EventStreamObserver responseObserver = new EventStreamObserver(this.cache, this);
        this.serviceStub.eventStream(Schema.EventStreamRequest.getDefaultInstance(), responseObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEventStreamAlive(Boolean alive) {
        block6: {
            Lock l = this.lock.writeLock();
            try {
                l.lock();
                this.eventStreamAlive = alive;
                if (!alive.booleanValue()) break block6;
                Object object = this.eventStreamAliveSync;
                synchronized (object) {
                    this.eventStreamAliveSync.notify();
                }
                this.eventStreamAttempt = 1;
                this.eventStreamRetryBackoff = 1000;
            }
            finally {
                l.unlock();
            }
        }
    }

    private <T> Boolean isEvaluationCacheable(ProviderEvaluation<T> evaluation) {
        String reason = evaluation.getReason();
        return reason != null && reason.equals(STATIC_REASON) && this.cacheAvailable() != false;
    }

    @Override
    public void restartEventStream() throws Exception {
        ++this.eventStreamAttempt;
        if (this.eventStreamAttempt > this.maxEventStreamRetries) {
            log.error("failed to connect to event stream, exhausted retries");
            return;
        }
        this.eventStreamRetryBackoff = 2 * this.eventStreamRetryBackoff;
        Thread.sleep(this.eventStreamRetryBackoff);
        this.handleEvents();
    }

    public Object getEventStreamAliveSync() {
        return this.eventStreamAliveSync;
    }
}

