/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd;

import com.google.protobuf.Value;
import dev.openfeature.contrib.providers.flagd.EventStreamCallback;
import dev.openfeature.contrib.providers.flagd.FlagdCache;
import dev.openfeature.flagd.grpc.Schema;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventStreamObserver
implements StreamObserver<Schema.EventStreamResponse> {
    private static final Logger log = LoggerFactory.getLogger(EventStreamObserver.class);
    private final EventStreamCallback callback;
    private final FlagdCache cache;
    private static final String configurationChange = "configuration_change";
    private static final String providerReady = "provider_ready";
    private static final String flagsKey = "flags";

    EventStreamObserver(FlagdCache cache, EventStreamCallback callback) {
        this.cache = cache;
        this.callback = callback;
    }

    public void onNext(Schema.EventStreamResponse value) {
        switch (value.getType()) {
            case "configuration_change": {
                this.handleConfigurationChangeEvent(value);
                break;
            }
            case "provider_ready": {
                this.handleProviderReadyEvent();
                break;
            }
            default: {
                log.debug("unhandled event type {}", (Object)value.getType());
                return;
            }
        }
    }

    public void onError(Throwable t) {
        log.error("event stream", t);
        if (this.cache.getEnabled().booleanValue()) {
            this.cache.clear();
        }
        this.callback.setEventStreamAlive(false);
        try {
            this.callback.restartEventStream();
        }
        catch (Exception e) {
            log.error("restart event stream", (Throwable)e);
        }
    }

    public void onCompleted() {
        if (this.cache.getEnabled().booleanValue()) {
            this.cache.clear();
        }
        this.callback.setEventStreamAlive(false);
    }

    private void handleConfigurationChangeEvent(Schema.EventStreamResponse value) {
        if (!this.cache.getEnabled().booleanValue()) {
            return;
        }
        Map data = value.getData().getFieldsMap();
        Value flagsValue = (Value)data.get(flagsKey);
        if (flagsValue == null) {
            this.cache.clear();
            return;
        }
        Map flags = flagsValue.getStructValue().getFieldsMap();
        for (String flagKey : flags.keySet()) {
            this.cache.remove(flagKey);
        }
    }

    private void handleProviderReadyEvent() {
        this.callback.setEventStreamAlive(true);
        if (this.cache.getEnabled().booleanValue()) {
            this.cache.clear();
        }
    }
}

