/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd;

import com.google.protobuf.Descriptors;
import com.google.protobuf.ListValue;
import com.google.protobuf.Message;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import dev.openfeature.contrib.providers.flagd.Config;
import dev.openfeature.contrib.providers.flagd.EventStreamCallback;
import dev.openfeature.contrib.providers.flagd.EventStreamObserver;
import dev.openfeature.contrib.providers.flagd.FlagdCache;
import dev.openfeature.contrib.providers.flagd.FlagdGrpcInterceptor;
import dev.openfeature.contrib.providers.flagd.FlagdOptions;
import dev.openfeature.contrib.providers.flagd.ResolveStrategy;
import dev.openfeature.contrib.providers.flagd.SimpleResolving;
import dev.openfeature.contrib.providers.flagd.SslConfigException;
import dev.openfeature.contrib.providers.flagd.TracedResolving;
import dev.openfeature.flagd.grpc.Schema;
import dev.openfeature.flagd.grpc.ServiceGrpc;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.FeatureProvider;
import dev.openfeature.sdk.Metadata;
import dev.openfeature.sdk.MutableStructure;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.Structure;
import dev.openfeature.sdk.Value;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlagdProvider
implements FeatureProvider,
EventStreamCallback {
    private static final Logger log = LoggerFactory.getLogger(FlagdProvider.class);
    private static final String FLAGD_PROVIDER = "flagD Provider";
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ServiceGrpc.ServiceBlockingStub serviceBlockingStub;
    private final ServiceGrpc.ServiceStub serviceStub;
    private final int maxEventStreamRetries;
    private final Object eventStreamAliveSync;
    private final FlagdCache cache;
    private final ResolveStrategy strategy;
    private boolean eventStreamAlive;
    private int eventStreamAttempt = 1;
    private int eventStreamRetryBackoff = 1000;
    private long deadline = 500L;

    public FlagdProvider() {
        this(FlagdOptions.builder().build());
    }

    public FlagdProvider(FlagdOptions options) {
        ManagedChannel channel = FlagdProvider.nettyChannel(options);
        this.serviceStub = ServiceGrpc.newStub((Channel)channel);
        this.serviceBlockingStub = ServiceGrpc.newBlockingStub((Channel)channel);
        this.strategy = options.getOpenTelemetry() == null ? new SimpleResolving() : new TracedResolving(options.getOpenTelemetry());
        this.maxEventStreamRetries = options.getMaxEventStreamRetries();
        this.cache = new FlagdCache(options.getCacheType(), options.getMaxCacheSize());
        this.eventStreamAliveSync = new Object();
        this.handleEvents();
    }

    @Deprecated
    public FlagdProvider(String socketPath) {
        this(FlagdProvider.buildServiceBlockingStub(null, null, null, null, socketPath), FlagdProvider.buildServiceStub(null, null, null, null, socketPath), Config.fallBackToEnvOrDefault("FLAGD_CACHE", "lru"), Config.fallBackToEnvOrDefault("FLAGD_MAX_CACHE_SIZE", 1000), Config.fallBackToEnvOrDefault("FLAGD_MAX_EVENT_STREAM_RETRIES", 5));
    }

    @Deprecated
    public FlagdProvider(String socketPath, String cache, int maxCacheSize, int maxEventStreamRetries) {
        this(FlagdProvider.buildServiceBlockingStub(null, null, null, null, socketPath), FlagdProvider.buildServiceStub(null, null, null, null, socketPath), cache, maxCacheSize, maxEventStreamRetries);
    }

    @Deprecated
    public FlagdProvider(String host, int port, boolean tls, String certPath) {
        this(FlagdProvider.buildServiceBlockingStub(host, port, tls, certPath, null), FlagdProvider.buildServiceStub(host, port, tls, certPath, null), Config.fallBackToEnvOrDefault("FLAGD_CACHE", "lru"), Config.fallBackToEnvOrDefault("FLAGD_MAX_CACHE_SIZE", 1000), Config.fallBackToEnvOrDefault("FLAGD_MAX_EVENT_STREAM_RETRIES", 5));
    }

    @Deprecated
    public FlagdProvider(String host, int port, boolean tls, String certPath, String cache, int maxCacheSize, int maxEventStreamRetries) {
        this(FlagdProvider.buildServiceBlockingStub(host, port, tls, certPath, null), FlagdProvider.buildServiceStub(host, port, tls, certPath, null), cache, maxCacheSize, maxEventStreamRetries);
    }

    FlagdProvider(ServiceGrpc.ServiceBlockingStub serviceBlockingStub, ServiceGrpc.ServiceStub serviceStub, String cache, int maxCacheSize, int maxEventStreamRetries) {
        this.serviceBlockingStub = serviceBlockingStub;
        this.serviceStub = serviceStub;
        this.strategy = new SimpleResolving();
        this.maxEventStreamRetries = maxEventStreamRetries;
        this.cache = new FlagdCache(cache, maxCacheSize);
        this.eventStreamAliveSync = new Object();
        this.handleEvents();
    }

    @Override
    public void restartEventStream() throws Exception {
        ++this.eventStreamAttempt;
        if (this.eventStreamAttempt > this.maxEventStreamRetries) {
            log.error("failed to connect to event stream, exhausted retries");
            return;
        }
        this.eventStreamRetryBackoff = 2 * this.eventStreamRetryBackoff;
        Thread.sleep(this.eventStreamRetryBackoff);
        this.handleEvents();
    }

    public Object getEventStreamAliveSync() {
        return this.eventStreamAliveSync;
    }

    public Metadata getMetadata() {
        return () -> FLAGD_PROVIDER;
    }

    public ProviderEvaluation<Boolean> getBooleanEvaluation(String key, Boolean defaultValue, EvaluationContext ctx) {
        Schema.ResolveBooleanRequest request = Schema.ResolveBooleanRequest.newBuilder().buildPartial();
        return this.resolve(key, ctx, request, ((ServiceGrpc.ServiceBlockingStub)this.serviceBlockingStub.withDeadlineAfter(this.deadline, TimeUnit.MILLISECONDS))::resolveBoolean, null);
    }

    public ProviderEvaluation<String> getStringEvaluation(String key, String defaultValue, EvaluationContext ctx) {
        Schema.ResolveStringRequest request = Schema.ResolveStringRequest.newBuilder().buildPartial();
        return this.resolve(key, ctx, request, ((ServiceGrpc.ServiceBlockingStub)this.serviceBlockingStub.withDeadlineAfter(this.deadline, TimeUnit.MILLISECONDS))::resolveString, null);
    }

    public ProviderEvaluation<Double> getDoubleEvaluation(String key, Double defaultValue, EvaluationContext ctx) {
        Schema.ResolveFloatRequest request = Schema.ResolveFloatRequest.newBuilder().buildPartial();
        return this.resolve(key, ctx, request, ((ServiceGrpc.ServiceBlockingStub)this.serviceBlockingStub.withDeadlineAfter(this.deadline, TimeUnit.MILLISECONDS))::resolveFloat, null);
    }

    public ProviderEvaluation<Integer> getIntegerEvaluation(String key, Integer defaultValue, EvaluationContext ctx) {
        Schema.ResolveIntRequest request = Schema.ResolveIntRequest.newBuilder().buildPartial();
        return this.resolve(key, ctx, request, ((ServiceGrpc.ServiceBlockingStub)this.serviceBlockingStub.withDeadlineAfter(this.deadline, TimeUnit.MILLISECONDS))::resolveInt, value -> ((Long)value).intValue());
    }

    public ProviderEvaluation<Value> getObjectEvaluation(String key, Value defaultValue, EvaluationContext ctx) {
        Schema.ResolveObjectRequest request = Schema.ResolveObjectRequest.newBuilder().buildPartial();
        return this.resolve(key, ctx, request, ((ServiceGrpc.ServiceBlockingStub)this.serviceBlockingStub.withDeadlineAfter(this.deadline, TimeUnit.MILLISECONDS))::resolveObject, value -> this.convertObjectResponse((Struct)value));
    }

    public FlagdProvider setDeadline(long deadlineMs) {
        this.deadline = deadlineMs;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEventStreamAlive(boolean alive) {
        block6: {
            Lock l = this.lock.writeLock();
            try {
                l.lock();
                this.eventStreamAlive = alive;
                if (!alive) break block6;
                Object object = this.eventStreamAliveSync;
                synchronized (object) {
                    this.eventStreamAliveSync.notify();
                }
                this.eventStreamAttempt = 1;
                this.eventStreamRetryBackoff = 1000;
            }
            finally {
                l.unlock();
            }
        }
    }

    private Value convertObjectResponse(Struct protobuf) {
        return this.convertProtobufMap(protobuf.getFieldsMap());
    }

    private Struct convertContext(EvaluationContext ctx) {
        return this.convertMap(ctx.asMap()).getStructValue();
    }

    private com.google.protobuf.Value convertAny(Value value) {
        if (value.isList()) {
            return this.convertList(value.asList());
        }
        if (value.isStructure()) {
            return this.convertMap(value.asStructure().asMap());
        }
        return this.convertPrimitive(value);
    }

    private Value convertAny(com.google.protobuf.Value protobuf) {
        if (protobuf.hasListValue()) {
            return this.convertList(protobuf.getListValue());
        }
        if (protobuf.hasStructValue()) {
            return this.convertProtobufMap(protobuf.getStructValue().getFieldsMap());
        }
        return this.convertPrimitive(protobuf);
    }

    private com.google.protobuf.Value convertMap(Map<String, Value> map) {
        HashMap values = new HashMap();
        map.keySet().stream().forEach(key -> {
            Value value = (Value)map.get(key);
            values.put(key, this.convertAny(value));
        });
        Struct struct = Struct.newBuilder().putAllFields(values).build();
        return com.google.protobuf.Value.newBuilder().setStructValue(struct).build();
    }

    private Value convertProtobufMap(Map<String, com.google.protobuf.Value> map) {
        HashMap values = new HashMap();
        map.keySet().stream().forEach(key -> {
            com.google.protobuf.Value value = (com.google.protobuf.Value)map.get(key);
            values.put(key, this.convertAny(value));
        });
        return new Value((Structure)new MutableStructure(values));
    }

    private com.google.protobuf.Value convertList(List<Value> values) {
        ListValue list = ListValue.newBuilder().addAllValues((Iterable)values.stream().map(v -> this.convertAny((Value)v)).collect(Collectors.toList())).build();
        return com.google.protobuf.Value.newBuilder().setListValue(list).build();
    }

    private Value convertList(ListValue protobuf) {
        return new Value(protobuf.getValuesList().stream().map(p -> this.convertAny((com.google.protobuf.Value)p)).collect(Collectors.toList()));
    }

    private com.google.protobuf.Value convertPrimitive(Value value) {
        Value.Builder builder = com.google.protobuf.Value.newBuilder();
        if (value.isBoolean()) {
            builder.setBoolValue(value.asBoolean().booleanValue());
        } else if (value.isString()) {
            builder.setStringValue(value.asString());
        } else if (value.isNumber()) {
            builder.setNumberValue(value.asDouble().doubleValue());
        } else {
            builder.setNullValue(NullValue.NULL_VALUE);
        }
        return builder.build();
    }

    private Value convertPrimitive(com.google.protobuf.Value protobuf) {
        Value value = protobuf.hasBoolValue() ? new Value(Boolean.valueOf(protobuf.getBoolValue())) : (protobuf.hasStringValue() ? new Value(protobuf.getStringValue()) : (protobuf.hasNumberValue() ? new Value(Double.valueOf(protobuf.getNumberValue())) : new Value()));
        return value;
    }

    @Deprecated
    private static NettyChannelBuilder channelBuilder(String host, Integer port, Boolean tls, String certPath, String socketPath) {
        host = host != null ? host : Config.fallBackToEnvOrDefault("FLAGD_HOST", "localhost");
        port = port != null ? port : Integer.parseInt(Config.fallBackToEnvOrDefault("FLAGD_PORT", "8013"));
        tls = tls != null ? tls : Boolean.parseBoolean(Config.fallBackToEnvOrDefault("FLAGD_TLS", "false"));
        certPath = certPath != null ? certPath : Config.fallBackToEnvOrDefault("FLAGD_SERVER_CERT_PATH", null);
        String string = socketPath = socketPath != null ? socketPath : Config.fallBackToEnvOrDefault("FLAGD_SOCKET_PATH", null);
        if (socketPath != null) {
            return NettyChannelBuilder.forAddress((SocketAddress)new DomainSocketAddress(socketPath)).eventLoopGroup((EventLoopGroup)new EpollEventLoopGroup()).channelType(EpollDomainSocketChannel.class).usePlaintext();
        }
        try {
            NettyChannelBuilder builder = NettyChannelBuilder.forAddress((String)host, (int)port);
            if (tls.booleanValue()) {
                SslContextBuilder sslContext = GrpcSslContexts.forClient();
                if (certPath != null) {
                    sslContext.trustManager(new File(certPath));
                }
                builder.sslContext(sslContext.build());
            } else {
                builder.usePlaintext();
            }
            return builder;
        }
        catch (SSLException ssle) {
            SslConfigException sslConfigException = new SslConfigException("Error with SSL configuration.");
            sslConfigException.initCause(ssle);
            throw sslConfigException;
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="certificate path is a user input")
    private static ManagedChannel nettyChannel(FlagdOptions options) {
        if (options.getSocketPath() != null) {
            return NettyChannelBuilder.forAddress((SocketAddress)new DomainSocketAddress(options.getSocketPath())).eventLoopGroup((EventLoopGroup)new EpollEventLoopGroup()).channelType(EpollDomainSocketChannel.class).usePlaintext().build();
        }
        try {
            NettyChannelBuilder builder = NettyChannelBuilder.forAddress((String)options.getHost(), (int)options.getPort());
            if (options.isTls()) {
                File file;
                SslContextBuilder sslContext = GrpcSslContexts.forClient();
                if (options.getCertPath() != null && (file = new File(options.getCertPath())).exists()) {
                    sslContext.trustManager(file);
                }
                builder.sslContext(sslContext.build());
            } else {
                builder.usePlaintext();
            }
            if (options.getOpenTelemetry() != null) {
                builder.intercept(new ClientInterceptor[]{new FlagdGrpcInterceptor(options.getOpenTelemetry())});
            }
            return builder.build();
        }
        catch (SSLException ssle) {
            SslConfigException sslConfigException = new SslConfigException("Error with SSL configuration.");
            sslConfigException.initCause(ssle);
            throw sslConfigException;
        }
    }

    @Deprecated
    private static ServiceGrpc.ServiceBlockingStub buildServiceBlockingStub(String host, Integer port, Boolean tls, String certPath, String socketPath) {
        return ServiceGrpc.newBlockingStub((Channel)FlagdProvider.channelBuilder(host, port, tls, certPath, socketPath).build());
    }

    @Deprecated
    private static ServiceGrpc.ServiceStub buildServiceStub(String host, Integer port, Boolean tls, String certPath, String socketPath) {
        return ServiceGrpc.newStub((Channel)FlagdProvider.channelBuilder(host, port, tls, certPath, socketPath).build());
    }

    private void handleEvents() {
        EventStreamObserver responseObserver = new EventStreamObserver(this.cache, this);
        this.serviceStub.eventStream(Schema.EventStreamRequest.getDefaultInstance(), responseObserver);
    }

    private <T> Boolean isEvaluationCacheable(ProviderEvaluation<T> evaluation) {
        String reason = evaluation.getReason();
        return reason != null && reason.equals("STATIC") && this.cacheAvailable() != false;
    }

    private Boolean cacheAvailable() {
        Lock l = this.lock.readLock();
        l.lock();
        Boolean available = this.cache.getEnabled() != false && this.eventStreamAlive;
        l.unlock();
        return available;
    }

    private <ValT, ReqT extends Message, ResT extends Message> ProviderEvaluation<ValT> resolve(String key, EvaluationContext ctx, ReqT request, Function<ReqT, ResT> resolverRef, Convert<ValT, Object> converter) {
        ProviderEvaluation<? extends Object> fromCache;
        if (this.cacheAvailable().booleanValue() && (fromCache = this.cache.get(key)) != null) {
            fromCache.setReason("CACHED");
            return fromCache;
        }
        Message req = request.newBuilderForType().setField(FlagdProvider.getFieldDescriptor(request, "flag_key"), (Object)key).setField(FlagdProvider.getFieldDescriptor(request, "context"), (Object)this.convertContext(ctx)).build();
        ResT response = this.strategy.resolve(resolverRef, req, key);
        Object value = converter == null ? FlagdProvider.getField(response, "value") : converter.convert(FlagdProvider.getField(response, "value"));
        ProviderEvaluation result = ProviderEvaluation.builder().value(value).variant((String)FlagdProvider.getField(response, "variant")).reason((String)FlagdProvider.getField(response, "reason")).build();
        if (this.isEvaluationCacheable(result).booleanValue()) {
            this.cache.put(key, (ProviderEvaluation<? extends Object>)result);
        }
        return result;
    }

    private static <T> T getField(Message message, String name) {
        return (T)message.getField(FlagdProvider.getFieldDescriptor(message, name));
    }

    private static Descriptors.FieldDescriptor getFieldDescriptor(Message message, String name) {
        return message.getDescriptorForType().findFieldByName(name);
    }

    @FunctionalInterface
    private static interface Convert<OutT, InT> {
        public OutT convert(InT var1);
    }
}

