/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.grpc;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapSetter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class FlagdGrpcInterceptor
implements ClientInterceptor {
    private static final TextMapSetter<Metadata> SETTER = new Setter();
    private final OpenTelemetry openTelemetry;

    public FlagdGrpcInterceptor(@Nonnull OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
        ClientCall call = channel.newCall(methodDescriptor, callOptions);
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                FlagdGrpcInterceptor.this.openTelemetry.getPropagators().getTextMapPropagator().inject(Context.current(), (Object)headers, SETTER);
                super.start(responseListener, headers);
            }
        };
    }

    static class Setter
    implements TextMapSetter<Metadata> {
        Setter() {
        }

        public void set(@Nullable Metadata carrier, String key, String value) {
            if (carrier == null) {
                return;
            }
            carrier.put(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)value);
        }
    }
}

