/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.grpc;

import dev.openfeature.contrib.providers.flagd.FlagdOptions;
import dev.openfeature.contrib.providers.flagd.cache.Cache;
import dev.openfeature.contrib.providers.flagd.grpc.EventStreamObserver;
import dev.openfeature.contrib.providers.flagd.grpc.FlagdGrpcInterceptor;
import dev.openfeature.contrib.providers.flagd.grpc.SslConfigException;
import dev.openfeature.flagd.grpc.Schema;
import dev.openfeature.flagd.grpc.ServiceGrpc;
import dev.openfeature.sdk.ProviderState;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.net.SocketAddress;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(justification="cache needs to be read and write by multiple objects")
public class GrpcConnector {
    private static final Logger log = LoggerFactory.getLogger(GrpcConnector.class);
    private final Object sync = new Object();
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final Random random = new Random();
    private final int maxJitter = 100;
    private final ServiceGrpc.ServiceBlockingStub serviceBlockingStub;
    private final ServiceGrpc.ServiceStub serviceStub;
    private final ManagedChannel channel;
    private final int maxEventStreamRetries;
    private final int startEventStreamRetryBackoff;
    private final long deadline;
    private final Cache cache;
    private final Consumer<ProviderState> stateConsumer;
    private int eventStreamAttempt = 1;
    private int eventStreamRetryBackoff;
    private Thread eventObserverThread;

    public GrpcConnector(FlagdOptions options, Cache cache, Consumer<ProviderState> stateConsumer) {
        this.channel = GrpcConnector.nettyChannel(options);
        this.serviceStub = ServiceGrpc.newStub((Channel)this.channel);
        this.serviceBlockingStub = ServiceGrpc.newBlockingStub((Channel)this.channel);
        this.maxEventStreamRetries = options.getMaxEventStreamRetries();
        this.startEventStreamRetryBackoff = options.getRetryBackoffMs();
        this.eventStreamRetryBackoff = options.getRetryBackoffMs();
        this.deadline = options.getDeadline();
        this.cache = cache;
        this.stateConsumer = stateConsumer;
    }

    public void initialize() throws Exception {
        this.eventObserverThread = new Thread(this::observeEventStream);
        this.eventObserverThread.start();
        GrpcConnector.busyWaitAndCheck(this.deadline, this.connected);
    }

    public void shutdown() throws Exception {
        if (this.eventObserverThread != null) {
            this.eventObserverThread.interrupt();
        }
        try {
            if (this.channel != null) {
                this.channel.shutdown();
                this.channel.awaitTermination(5L, TimeUnit.SECONDS);
            }
        }
        finally {
            this.cache.clear();
            if (this.channel != null) {
                this.channel.shutdownNow();
            }
        }
    }

    public ServiceGrpc.ServiceBlockingStub getResolver() {
        return (ServiceGrpc.ServiceBlockingStub)this.serviceBlockingStub.withDeadlineAfter(this.deadline, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void observeEventStream() {
        while (this.eventStreamAttempt <= this.maxEventStreamRetries) {
            EventStreamObserver responseObserver = new EventStreamObserver(this.sync, this.cache, this::grpcStateConsumer);
            this.serviceStub.eventStream(Schema.EventStreamRequest.getDefaultInstance(), responseObserver);
            try {
                Object object = this.sync;
                synchronized (object) {
                    this.sync.wait();
                }
            }
            catch (InterruptedException e) {
                log.debug("interruption while waiting for condition", (Throwable)e);
                return;
            }
            ++this.eventStreamAttempt;
            this.eventStreamRetryBackoff = 2 * this.eventStreamRetryBackoff + this.random.nextInt(100);
            try {
                Thread.sleep(this.eventStreamRetryBackoff);
            }
            catch (InterruptedException e) {
                log.warn("interrupted while restarting gRPC Event Stream");
                return;
            }
        }
        log.error("failed to connect to event stream, exhausted retries");
        this.grpcStateConsumer(ProviderState.ERROR);
    }

    private void grpcStateConsumer(ProviderState state) {
        if (ProviderState.READY.equals((Object)state)) {
            this.eventStreamAttempt = 1;
            this.eventStreamRetryBackoff = this.startEventStreamRetryBackoff;
            this.connected.set(true);
        } else if (ProviderState.ERROR.equals((Object)state)) {
            this.connected.set(false);
        }
        this.stateConsumer.accept(state);
    }

    private static void busyWaitAndCheck(Long deadline, AtomicBoolean check) throws InterruptedException {
        long start = System.currentTimeMillis();
        do {
            if (deadline <= System.currentTimeMillis() - start) {
                throw new RuntimeException(String.format("Initialization not complete after %d ms", deadline));
            }
            Thread.sleep(50L);
        } while (!check.get());
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="certificate path is a user input")
    private static ManagedChannel nettyChannel(FlagdOptions options) {
        if (options.getSocketPath() != null) {
            if (!Epoll.isAvailable()) {
                throw new IllegalStateException("unix socket cannot be used", Epoll.unavailabilityCause());
            }
            return NettyChannelBuilder.forAddress((SocketAddress)new DomainSocketAddress(options.getSocketPath())).eventLoopGroup((EventLoopGroup)new EpollEventLoopGroup()).channelType(EpollDomainSocketChannel.class).usePlaintext().build();
        }
        try {
            NettyChannelBuilder builder = NettyChannelBuilder.forAddress((String)options.getHost(), (int)options.getPort());
            if (options.isTls()) {
                File file;
                SslContextBuilder sslContext = GrpcSslContexts.forClient();
                if (options.getCertPath() != null && (file = new File(options.getCertPath())).exists()) {
                    sslContext.trustManager(file);
                }
                builder.sslContext(sslContext.build());
            } else {
                builder.usePlaintext();
            }
            if (options.getOpenTelemetry() != null) {
                builder.intercept(new ClientInterceptor[]{new FlagdGrpcInterceptor(options.getOpenTelemetry())});
            }
            return builder.build();
        }
        catch (SSLException ssle) {
            SslConfigException sslConfigException = new SslConfigException("Error with SSL configuration.");
            sslConfigException.initCause(ssle);
            throw sslConfigException;
        }
    }
}

