/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.grpc;

import com.google.protobuf.Value;
import dev.openfeature.contrib.providers.flagd.resolver.grpc.cache.Cache;
import dev.openfeature.flagd.grpc.Schema;
import dev.openfeature.sdk.ProviderState;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(justification="cache needs to be read and write by multiple objects")
class EventStreamObserver
implements StreamObserver<Schema.EventStreamResponse> {
    private static final Logger log = LoggerFactory.getLogger(EventStreamObserver.class);
    private final Consumer<ProviderState> stateConsumer;
    private final Object sync;
    private final Cache cache;
    private static final String CONFIGURATION_CHANGE = "configuration_change";
    private static final String PROVIDER_READY = "provider_ready";
    static final String FLAGS_KEY = "flags";

    EventStreamObserver(Object sync, Cache cache, Consumer<ProviderState> stateConsumer) {
        this.sync = sync;
        this.cache = cache;
        this.stateConsumer = stateConsumer;
    }

    public void onNext(Schema.EventStreamResponse value) {
        switch (value.getType()) {
            case "configuration_change": {
                this.handleConfigurationChangeEvent(value);
                break;
            }
            case "provider_ready": {
                this.handleProviderReadyEvent();
                break;
            }
            default: {
                log.debug("unhandled event type {}", (Object)value.getType());
            }
        }
    }

    public void onError(Throwable t) {
        log.error("event stream", t);
        if (this.cache.getEnabled().booleanValue()) {
            this.cache.clear();
        }
        this.stateConsumer.accept(ProviderState.ERROR);
        this.handleEndOfStream();
    }

    public void onCompleted() {
        if (this.cache.getEnabled().booleanValue()) {
            this.cache.clear();
        }
        this.stateConsumer.accept(ProviderState.ERROR);
        this.handleEndOfStream();
    }

    private void handleConfigurationChangeEvent(Schema.EventStreamResponse value) {
        this.stateConsumer.accept(ProviderState.READY);
        if (!this.cache.getEnabled().booleanValue()) {
            return;
        }
        Map data = value.getData().getFieldsMap();
        Value flagsValue = (Value)data.get(FLAGS_KEY);
        if (flagsValue == null) {
            this.cache.clear();
            return;
        }
        Map flags = flagsValue.getStructValue().getFieldsMap();
        for (String flagKey : flags.keySet()) {
            this.cache.remove(flagKey);
        }
    }

    private void handleProviderReadyEvent() {
        this.stateConsumer.accept(ProviderState.READY);
        if (this.cache.getEnabled().booleanValue()) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEndOfStream() {
        Object object = this.sync;
        synchronized (object) {
            this.sync.notify();
        }
    }
}

