/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.grpc;

import com.google.protobuf.Descriptors;
import com.google.protobuf.ListValue;
import com.google.protobuf.Message;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import dev.openfeature.contrib.providers.flagd.FlagdOptions;
import dev.openfeature.contrib.providers.flagd.resolver.Resolver;
import dev.openfeature.contrib.providers.flagd.resolver.grpc.Convert;
import dev.openfeature.contrib.providers.flagd.resolver.grpc.GrpcConnector;
import dev.openfeature.contrib.providers.flagd.resolver.grpc.cache.Cache;
import dev.openfeature.contrib.providers.flagd.resolver.grpc.strategy.ResolveFactory;
import dev.openfeature.contrib.providers.flagd.resolver.grpc.strategy.ResolveStrategy;
import dev.openfeature.flagd.grpc.Schema;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.ImmutableMetadata;
import dev.openfeature.sdk.MutableStructure;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.ProviderState;
import dev.openfeature.sdk.Structure;
import dev.openfeature.sdk.Value;
import dev.openfeature.sdk.exceptions.FlagNotFoundError;
import dev.openfeature.sdk.exceptions.GeneralError;
import dev.openfeature.sdk.exceptions.OpenFeatureError;
import dev.openfeature.sdk.exceptions.ParseError;
import dev.openfeature.sdk.exceptions.TypeMismatchError;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@SuppressFBWarnings(justification="cache needs to be read and write by multiple objects")
public final class GrpcResolver
implements Resolver {
    private final GrpcConnector connector;
    private final Cache cache;
    private final ResolveStrategy strategy;
    private final Supplier<ProviderState> stateSupplier;

    public GrpcResolver(FlagdOptions options, Cache cache, Supplier<ProviderState> stateSupplier, Consumer<ProviderState> stateConsumer) {
        this.cache = cache;
        this.stateSupplier = stateSupplier;
        this.strategy = ResolveFactory.getStrategy(options);
        this.connector = new GrpcConnector(options, cache, stateConsumer);
    }

    @Override
    public void init() throws Exception {
        this.connector.initialize();
    }

    @Override
    public void shutdown() throws Exception {
        this.connector.shutdown();
    }

    @Override
    public ProviderEvaluation<Boolean> booleanEvaluation(String key, Boolean defaultValue, EvaluationContext ctx) {
        Schema.ResolveBooleanRequest request = Schema.ResolveBooleanRequest.newBuilder().buildPartial();
        return this.resolve(key, ctx, request, this.connector.getResolver()::resolveBoolean, null);
    }

    @Override
    public ProviderEvaluation<String> stringEvaluation(String key, String defaultValue, EvaluationContext ctx) {
        Schema.ResolveStringRequest request = Schema.ResolveStringRequest.newBuilder().buildPartial();
        return this.resolve(key, ctx, request, this.connector.getResolver()::resolveString, null);
    }

    @Override
    public ProviderEvaluation<Double> doubleEvaluation(String key, Double defaultValue, EvaluationContext ctx) {
        Schema.ResolveFloatRequest request = Schema.ResolveFloatRequest.newBuilder().buildPartial();
        return this.resolve(key, ctx, request, this.connector.getResolver()::resolveFloat, null);
    }

    @Override
    public ProviderEvaluation<Integer> integerEvaluation(String key, Integer defaultValue, EvaluationContext ctx) {
        Schema.ResolveIntRequest request = Schema.ResolveIntRequest.newBuilder().buildPartial();
        return this.resolve(key, ctx, request, this.connector.getResolver()::resolveInt, value -> ((Long)value).intValue());
    }

    @Override
    public ProviderEvaluation<Value> objectEvaluation(String key, Value defaultValue, EvaluationContext ctx) {
        Schema.ResolveObjectRequest request = Schema.ResolveObjectRequest.newBuilder().buildPartial();
        return this.resolve(key, ctx, request, this.connector.getResolver()::resolveObject, value -> GrpcResolver.convertObjectResponse((Struct)value));
    }

    private <ValT, ReqT extends Message, ResT extends Message> ProviderEvaluation<ValT> resolve(String key, EvaluationContext ctx, ReqT request, Function<ReqT, ResT> resolverRef, Convert<ValT, Object> converter) {
        ResT response;
        ProviderEvaluation<? extends Object> fromCache;
        if (this.cacheAvailable().booleanValue() && (fromCache = this.cache.get(key)) != null) {
            fromCache.setReason("CACHED");
            return fromCache;
        }
        Message req = request.newBuilderForType().setField(GrpcResolver.getFieldDescriptor(request, "flag_key"), (Object)key).setField(GrpcResolver.getFieldDescriptor(request, "context"), (Object)GrpcResolver.convertContext(ctx)).build();
        try {
            response = this.strategy.resolve(resolverRef, req, key);
        }
        catch (Exception e) {
            OpenFeatureError openFeatureError = this.mapError(e);
            throw openFeatureError;
        }
        Object value = converter == null ? GrpcResolver.getField(response, "value") : converter.convert(GrpcResolver.getField(response, "value"));
        ImmutableMetadata immutableMetadata = GrpcResolver.metadataFromResponse(response);
        ProviderEvaluation result = ProviderEvaluation.builder().value(value).variant((String)GrpcResolver.getField(response, "variant")).reason((String)GrpcResolver.getField(response, "reason")).flagMetadata(immutableMetadata).build();
        if (this.isEvaluationCacheable(result).booleanValue()) {
            this.cache.put(key, (ProviderEvaluation<? extends Object>)result);
        }
        return result;
    }

    private <T> Boolean isEvaluationCacheable(ProviderEvaluation<T> evaluation) {
        String reason = evaluation.getReason();
        return reason != null && reason.equals("STATIC") && this.cacheAvailable() != false;
    }

    private Boolean cacheAvailable() {
        return this.cache.getEnabled() != false && ProviderState.READY.equals((Object)this.stateSupplier.get());
    }

    private static Value convertObjectResponse(Struct protobuf) {
        return GrpcResolver.convertProtobufMap(protobuf.getFieldsMap());
    }

    private static Struct convertContext(EvaluationContext ctx) {
        return GrpcResolver.convertMap(ctx.asMap()).getStructValue();
    }

    private static com.google.protobuf.Value convertAny(Value value) {
        if (value.isList()) {
            return GrpcResolver.convertList(value.asList());
        }
        if (value.isStructure()) {
            return GrpcResolver.convertMap(value.asStructure().asMap());
        }
        return GrpcResolver.convertPrimitive(value);
    }

    private static Value convertAny(com.google.protobuf.Value protobuf) {
        if (protobuf.hasListValue()) {
            return GrpcResolver.convertList(protobuf.getListValue());
        }
        if (protobuf.hasStructValue()) {
            return GrpcResolver.convertProtobufMap(protobuf.getStructValue().getFieldsMap());
        }
        return GrpcResolver.convertPrimitive(protobuf);
    }

    private static com.google.protobuf.Value convertMap(Map<String, Value> map) {
        HashMap values = new HashMap();
        map.keySet().forEach(key -> {
            Value value = (Value)map.get(key);
            values.put(key, GrpcResolver.convertAny(value));
        });
        Struct struct = Struct.newBuilder().putAllFields(values).build();
        return com.google.protobuf.Value.newBuilder().setStructValue(struct).build();
    }

    private static Value convertProtobufMap(Map<String, com.google.protobuf.Value> map) {
        HashMap values = new HashMap();
        map.keySet().forEach(key -> {
            com.google.protobuf.Value value = (com.google.protobuf.Value)map.get(key);
            values.put(key, GrpcResolver.convertAny(value));
        });
        return new Value((Structure)new MutableStructure(values));
    }

    private static com.google.protobuf.Value convertList(List<Value> values) {
        ListValue list = ListValue.newBuilder().addAllValues((Iterable)values.stream().map(v -> GrpcResolver.convertAny(v)).collect(Collectors.toList())).build();
        return com.google.protobuf.Value.newBuilder().setListValue(list).build();
    }

    private static Value convertList(ListValue protobuf) {
        return new Value(protobuf.getValuesList().stream().map(p -> GrpcResolver.convertAny(p)).collect(Collectors.toList()));
    }

    private static com.google.protobuf.Value convertPrimitive(Value value) {
        Value.Builder builder = com.google.protobuf.Value.newBuilder();
        if (value.isBoolean()) {
            builder.setBoolValue(value.asBoolean().booleanValue());
        } else if (value.isString()) {
            builder.setStringValue(value.asString());
        } else if (value.isNumber()) {
            builder.setNumberValue(value.asDouble().doubleValue());
        } else {
            builder.setNullValue(NullValue.NULL_VALUE);
        }
        return builder.build();
    }

    private static Value convertPrimitive(com.google.protobuf.Value protobuf) {
        Value value = protobuf.hasBoolValue() ? new Value(Boolean.valueOf(protobuf.getBoolValue())) : (protobuf.hasStringValue() ? new Value(protobuf.getStringValue()) : (protobuf.hasNumberValue() ? new Value(Double.valueOf(protobuf.getNumberValue())) : new Value()));
        return value;
    }

    private static <T> T getField(Message message, String name) {
        return (T)message.getField(GrpcResolver.getFieldDescriptor(message, name));
    }

    private static Descriptors.FieldDescriptor getFieldDescriptor(Message message, String name) {
        return message.getDescriptorForType().findFieldByName(name);
    }

    private static ImmutableMetadata metadataFromResponse(Message response) {
        Object metadata = response.getField(GrpcResolver.getFieldDescriptor(response, "metadata"));
        if (!(metadata instanceof Struct)) {
            return ImmutableMetadata.builder().build();
        }
        Struct struct = (Struct)metadata;
        ImmutableMetadata.ImmutableMetadataBuilder builder = ImmutableMetadata.builder();
        for (Map.Entry entry : struct.getFieldsMap().entrySet()) {
            if (((com.google.protobuf.Value)entry.getValue()).hasStringValue()) {
                builder.addString((String)entry.getKey(), ((com.google.protobuf.Value)entry.getValue()).getStringValue());
                continue;
            }
            if (((com.google.protobuf.Value)entry.getValue()).hasBoolValue()) {
                builder.addBoolean((String)entry.getKey(), Boolean.valueOf(((com.google.protobuf.Value)entry.getValue()).getBoolValue()));
                continue;
            }
            if (!((com.google.protobuf.Value)entry.getValue()).hasNumberValue()) continue;
            builder.addDouble((String)entry.getKey(), Double.valueOf(((com.google.protobuf.Value)entry.getValue()).getNumberValue()));
        }
        return builder.build();
    }

    private OpenFeatureError mapError(Exception e) {
        if (e instanceof StatusRuntimeException) {
            Status.Code code = ((StatusRuntimeException)e).getStatus().getCode();
            switch (code) {
                case DATA_LOSS: {
                    return new ParseError(e.getMessage());
                }
                case INVALID_ARGUMENT: {
                    return new TypeMismatchError(e.getMessage());
                }
                case NOT_FOUND: {
                    return new FlagNotFoundError(e.getMessage());
                }
            }
            return new GeneralError(e.getMessage());
        }
        return new GeneralError(e.getMessage());
    }
}

