/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.process.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import dev.openfeature.contrib.providers.flagd.resolver.process.model.FeatureFlag;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Feature flag comes as a Json configuration, hence they must be exposed")
public class FlagParser {
    private static final Logger log = Logger.getLogger(FlagParser.class.getName());
    private static final String FLAG_KEY = "flags";
    private static final String EVALUATOR_KEY = "$evaluators";
    private static final String REPLACER_FORMAT = "\"\\$ref\":(\\s)*\"%s\"";
    private static final String SCHEMA_RESOURCE = "flagd-definitions.json";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Map<String, Pattern> PATTERN_MAP = new HashMap<String, Pattern>();
    private static final Pattern REG_BRACKETS = Pattern.compile("^[^{]*\\{|}[^}]*$");
    private static JsonSchema SCHEMA_VALIDATOR;

    public static Map<String, FeatureFlag> parseString(String configuration) throws IOException {
        if (SCHEMA_VALIDATOR != null) {
            try (JsonParser parser = MAPPER.createParser(configuration);){
                Set validationMessages = SCHEMA_VALIDATOR.validate((JsonNode)parser.readValueAsTree());
                if (!validationMessages.isEmpty()) {
                    throw new IllegalArgumentException(String.format("Failed to parse configurations. %d validation error(s) reported.", validationMessages.size()));
                }
            }
        }
        String transposedConfiguration = FlagParser.transposeEvaluators(configuration);
        HashMap<String, FeatureFlag> flagMap = new HashMap<String, FeatureFlag>();
        try (JsonParser parser = MAPPER.createParser(transposedConfiguration);){
            TreeNode treeNode = parser.readValueAsTree();
            TreeNode flagNode = treeNode.get(FLAG_KEY);
            if (flagNode == null) {
                throw new IllegalArgumentException("No flag configurations found in the payload");
            }
            Iterator it = flagNode.fieldNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                flagMap.put(key, (FeatureFlag)MAPPER.treeToValue(flagNode.get(key), FeatureFlag.class));
            }
        }
        return flagMap;
    }

    private static String transposeEvaluators(String configuration) throws IOException {
        try (JsonParser parser = MAPPER.createParser(configuration);){
            TreeNode treeNode = parser.readValueAsTree();
            TreeNode evaluators = treeNode.get(EVALUATOR_KEY);
            if (evaluators == null || evaluators.size() == 0) {
                String string = configuration;
                return string;
            }
            String replacedConfigurations = configuration;
            Iterator evalFields = evaluators.fieldNames();
            while (evalFields.hasNext()) {
                String evalName = (String)evalFields.next();
                String replacer = REG_BRACKETS.matcher(evaluators.get(evalName).toString()).replaceAll("");
                String replacePattern = String.format(REPLACER_FORMAT, evalName);
                Pattern reg_replace = PATTERN_MAP.computeIfAbsent(replacePattern, s -> Pattern.compile(replacePattern));
                replacedConfigurations = reg_replace.matcher(replacedConfigurations).replaceAll(replacer);
            }
            String string = replacedConfigurations;
            return string;
        }
    }

    static {
        try (InputStream schema = FlagParser.class.getClassLoader().getResourceAsStream(SCHEMA_RESOURCE);){
            if (schema == null) {
                log.log(Level.WARNING, String.format("Resource %s not found", SCHEMA_RESOURCE));
            } else {
                int size;
                ByteArrayOutputStream result = new ByteArrayOutputStream();
                byte[] buffer = new byte[512];
                while (0 < (size = schema.read(buffer))) {
                    result.write(buffer, 0, size);
                }
                JsonSchemaFactory instance = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7);
                SCHEMA_VALIDATOR = instance.getSchema(result.toString("UTF-8"));
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, String.format("Error loading resource %s, schema validation will be skipped", SCHEMA_RESOURCE), e);
        }
    }
}

