/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.grpc;

import dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.grpc.GrpcResponseModel;
import dev.openfeature.flagd.sync.SyncService;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

class GrpcStreamHandler
implements StreamObserver<SyncService.SyncFlagsResponse> {
    private static final Logger log = Logger.getLogger(GrpcStreamHandler.class.getName());
    private final BlockingQueue<GrpcResponseModel> blockingQueue;

    GrpcStreamHandler(BlockingQueue<GrpcResponseModel> queue) {
        this.blockingQueue = queue;
    }

    public void onNext(SyncService.SyncFlagsResponse syncFlagsResponse) {
        if (!this.blockingQueue.offer(new GrpcResponseModel(syncFlagsResponse))) {
            log.log(Level.WARNING, "failed to write sync response to queue");
        }
    }

    public void onError(Throwable throwable) {
        if (!this.blockingQueue.offer(new GrpcResponseModel(throwable))) {
            log.log(Level.WARNING, "failed to write error response to queue");
        }
    }

    public void onCompleted() {
        if (!this.blockingQueue.offer(new GrpcResponseModel(true))) {
            log.log(Level.WARNING, "failed to write complete status to queue");
        }
    }
}

