/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd;

import dev.openfeature.contrib.providers.flagd.Config;
import io.opentelemetry.api.OpenTelemetry;
import javax.annotation.Nonnull;

public class FlagdOptions {
    private Config.Evaluator resolverType;
    private String host;
    private int port;
    private boolean tls;
    private String certPath;
    private String socketPath;
    private String cacheType;
    private int maxCacheSize;
    private int maxEventStreamRetries;
    private int retryBackoffMs;
    private int deadline;
    private String selector;
    private String offlineFlagSourcePath;
    private boolean isOffline;
    private OpenTelemetry openTelemetry;

    private static Config.Evaluator $default$resolverType() {
        return Config.DEFAULT_RESOLVER_TYPE;
    }

    private static String $default$host() {
        return Config.fallBackToEnvOrDefault("FLAGD_HOST", "localhost");
    }

    private static int $default$port() {
        return Integer.parseInt(Config.fallBackToEnvOrDefault("FLAGD_PORT", "8013"));
    }

    private static boolean $default$tls() {
        return Boolean.parseBoolean(Config.fallBackToEnvOrDefault("FLAGD_TLS", "false"));
    }

    private static String $default$certPath() {
        return Config.fallBackToEnvOrDefault("FLAGD_SERVER_CERT_PATH", null);
    }

    private static String $default$socketPath() {
        return Config.fallBackToEnvOrDefault("FLAGD_SOCKET_PATH", null);
    }

    private static String $default$cacheType() {
        return Config.fallBackToEnvOrDefault("FLAGD_CACHE", "lru");
    }

    private static int $default$maxCacheSize() {
        return Config.fallBackToEnvOrDefault("FLAGD_MAX_CACHE_SIZE", 1000);
    }

    private static int $default$maxEventStreamRetries() {
        return Config.fallBackToEnvOrDefault("FLAGD_MAX_EVENT_STREAM_RETRIES", 5);
    }

    private static int $default$retryBackoffMs() {
        return Config.fallBackToEnvOrDefault("FLAGD_RETRY_BACKOFF_MS", 1000);
    }

    private static int $default$deadline() {
        return Config.fallBackToEnvOrDefault("FLAGD_DEADLINE_MS", 500);
    }

    private static String $default$selector() {
        return Config.fallBackToEnvOrDefault("FLAGD_SOURCE_SELECTOR", null);
    }

    FlagdOptions(Config.Evaluator resolverType, String host, int port, boolean tls, String certPath, String socketPath, String cacheType, int maxCacheSize, int maxEventStreamRetries, int retryBackoffMs, int deadline, String selector, String offlineFlagSourcePath, boolean isOffline, OpenTelemetry openTelemetry) {
        this.resolverType = resolverType;
        this.host = host;
        this.port = port;
        this.tls = tls;
        this.certPath = certPath;
        this.socketPath = socketPath;
        this.cacheType = cacheType;
        this.maxCacheSize = maxCacheSize;
        this.maxEventStreamRetries = maxEventStreamRetries;
        this.retryBackoffMs = retryBackoffMs;
        this.deadline = deadline;
        this.selector = selector;
        this.offlineFlagSourcePath = offlineFlagSourcePath;
        this.isOffline = isOffline;
        this.openTelemetry = openTelemetry;
    }

    public static FlagdOptionsBuilder builder() {
        return new FlagdOptionsBuilder();
    }

    public Config.Evaluator getResolverType() {
        return this.resolverType;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isTls() {
        return this.tls;
    }

    public String getCertPath() {
        return this.certPath;
    }

    public String getSocketPath() {
        return this.socketPath;
    }

    public String getCacheType() {
        return this.cacheType;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public int getMaxEventStreamRetries() {
        return this.maxEventStreamRetries;
    }

    public int getRetryBackoffMs() {
        return this.retryBackoffMs;
    }

    public int getDeadline() {
        return this.deadline;
    }

    public String getSelector() {
        return this.selector;
    }

    public String getOfflineFlagSourcePath() {
        return this.offlineFlagSourcePath;
    }

    public boolean isOffline() {
        return this.isOffline;
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    public static class FlagdOptionsBuilder {
        private boolean resolverType$set;
        private Config.Evaluator resolverType$value;
        private boolean host$set;
        private String host$value;
        private boolean port$set;
        private int port$value;
        private boolean tls$set;
        private boolean tls$value;
        private boolean certPath$set;
        private String certPath$value;
        private boolean socketPath$set;
        private String socketPath$value;
        private boolean cacheType$set;
        private String cacheType$value;
        private boolean maxCacheSize$set;
        private int maxCacheSize$value;
        private boolean maxEventStreamRetries$set;
        private int maxEventStreamRetries$value;
        private boolean retryBackoffMs$set;
        private int retryBackoffMs$value;
        private boolean deadline$set;
        private int deadline$value;
        private boolean selector$set;
        private String selector$value;
        private String offlineFlagSourcePath;
        private boolean isOffline;
        private OpenTelemetry openTelemetry;

        public FlagdOptionsBuilder offlineFlagSourcePath(@Nonnull String offlineFlagSourcePath) {
            this.isOffline = true;
            this.offlineFlagSourcePath = offlineFlagSourcePath;
            return this;
        }

        private FlagdOptionsBuilder isOffline(boolean isOffline) {
            return this;
        }

        FlagdOptionsBuilder() {
        }

        public FlagdOptionsBuilder resolverType(Config.Evaluator resolverType) {
            this.resolverType$value = resolverType;
            this.resolverType$set = true;
            return this;
        }

        public FlagdOptionsBuilder host(String host) {
            this.host$value = host;
            this.host$set = true;
            return this;
        }

        public FlagdOptionsBuilder port(int port) {
            this.port$value = port;
            this.port$set = true;
            return this;
        }

        public FlagdOptionsBuilder tls(boolean tls) {
            this.tls$value = tls;
            this.tls$set = true;
            return this;
        }

        public FlagdOptionsBuilder certPath(String certPath) {
            this.certPath$value = certPath;
            this.certPath$set = true;
            return this;
        }

        public FlagdOptionsBuilder socketPath(String socketPath) {
            this.socketPath$value = socketPath;
            this.socketPath$set = true;
            return this;
        }

        public FlagdOptionsBuilder cacheType(String cacheType) {
            this.cacheType$value = cacheType;
            this.cacheType$set = true;
            return this;
        }

        public FlagdOptionsBuilder maxCacheSize(int maxCacheSize) {
            this.maxCacheSize$value = maxCacheSize;
            this.maxCacheSize$set = true;
            return this;
        }

        public FlagdOptionsBuilder maxEventStreamRetries(int maxEventStreamRetries) {
            this.maxEventStreamRetries$value = maxEventStreamRetries;
            this.maxEventStreamRetries$set = true;
            return this;
        }

        public FlagdOptionsBuilder retryBackoffMs(int retryBackoffMs) {
            this.retryBackoffMs$value = retryBackoffMs;
            this.retryBackoffMs$set = true;
            return this;
        }

        public FlagdOptionsBuilder deadline(int deadline) {
            this.deadline$value = deadline;
            this.deadline$set = true;
            return this;
        }

        public FlagdOptionsBuilder selector(String selector) {
            this.selector$value = selector;
            this.selector$set = true;
            return this;
        }

        public FlagdOptionsBuilder openTelemetry(OpenTelemetry openTelemetry) {
            this.openTelemetry = openTelemetry;
            return this;
        }

        public FlagdOptions build() {
            Config.Evaluator resolverType$value = this.resolverType$value;
            if (!this.resolverType$set) {
                resolverType$value = FlagdOptions.$default$resolverType();
            }
            String host$value = this.host$value;
            if (!this.host$set) {
                host$value = FlagdOptions.$default$host();
            }
            int port$value = this.port$value;
            if (!this.port$set) {
                port$value = FlagdOptions.$default$port();
            }
            boolean tls$value = this.tls$value;
            if (!this.tls$set) {
                tls$value = FlagdOptions.$default$tls();
            }
            String certPath$value = this.certPath$value;
            if (!this.certPath$set) {
                certPath$value = FlagdOptions.$default$certPath();
            }
            String socketPath$value = this.socketPath$value;
            if (!this.socketPath$set) {
                socketPath$value = FlagdOptions.$default$socketPath();
            }
            String cacheType$value = this.cacheType$value;
            if (!this.cacheType$set) {
                cacheType$value = FlagdOptions.$default$cacheType();
            }
            int maxCacheSize$value = this.maxCacheSize$value;
            if (!this.maxCacheSize$set) {
                maxCacheSize$value = FlagdOptions.$default$maxCacheSize();
            }
            int maxEventStreamRetries$value = this.maxEventStreamRetries$value;
            if (!this.maxEventStreamRetries$set) {
                maxEventStreamRetries$value = FlagdOptions.$default$maxEventStreamRetries();
            }
            int retryBackoffMs$value = this.retryBackoffMs$value;
            if (!this.retryBackoffMs$set) {
                retryBackoffMs$value = FlagdOptions.$default$retryBackoffMs();
            }
            int deadline$value = this.deadline$value;
            if (!this.deadline$set) {
                deadline$value = FlagdOptions.$default$deadline();
            }
            String selector$value = this.selector$value;
            if (!this.selector$set) {
                selector$value = FlagdOptions.$default$selector();
            }
            return new FlagdOptions(resolverType$value, host$value, port$value, tls$value, certPath$value, socketPath$value, cacheType$value, maxCacheSize$value, maxEventStreamRetries$value, retryBackoffMs$value, deadline$value, selector$value, this.offlineFlagSourcePath, this.isOffline, this.openTelemetry);
        }

        public String toString() {
            return "FlagdOptions.FlagdOptionsBuilder(resolverType$value=" + (Object)((Object)this.resolverType$value) + ", host$value=" + this.host$value + ", port$value=" + this.port$value + ", tls$value=" + this.tls$value + ", certPath$value=" + this.certPath$value + ", socketPath$value=" + this.socketPath$value + ", cacheType$value=" + this.cacheType$value + ", maxCacheSize$value=" + this.maxCacheSize$value + ", maxEventStreamRetries$value=" + this.maxEventStreamRetries$value + ", retryBackoffMs$value=" + this.retryBackoffMs$value + ", deadline$value=" + this.deadline$value + ", selector$value=" + this.selector$value + ", offlineFlagSourcePath=" + this.offlineFlagSourcePath + ", isOffline=" + this.isOffline + ", openTelemetry=" + this.openTelemetry + ")";
        }
    }
}

