/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.file;

import dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.Connector;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.StreamPayload;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.StreamPayloadType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "PATH_TRAVERSAL_IN"}, justification="File connector read feature flag from a file source.")
public class FileConnector
implements Connector {
    private static final Logger log = LoggerFactory.getLogger(FileConnector.class);
    private final String flagSourcePath;
    private final BlockingQueue<StreamPayload> queue = new LinkedBlockingQueue<StreamPayload>(1);

    public FileConnector(String flagSourcePath) {
        this.flagSourcePath = flagSourcePath;
    }

    @Override
    public void init() throws IOException {
        String flagData = new String(Files.readAllBytes(Paths.get(this.flagSourcePath, new String[0])), StandardCharsets.UTF_8);
        if (!this.queue.offer(new StreamPayload(StreamPayloadType.DATA, flagData))) {
            throw new RuntimeException("Unable to write to queue. Queue is full.");
        }
        log.info(String.format("Using feature flag configurations from file %s", this.flagSourcePath));
    }

    @Override
    public BlockingQueue<StreamPayload> getStream() {
        return this.queue;
    }

    @Override
    public void shutdown() throws InterruptedException {
    }
}

