/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.process.targeting;

import dev.openfeature.contrib.providers.flagd.resolver.process.targeting.Fractional;
import dev.openfeature.contrib.providers.flagd.resolver.process.targeting.SemVer;
import dev.openfeature.contrib.providers.flagd.resolver.process.targeting.StringComp;
import dev.openfeature.contrib.providers.flagd.resolver.process.targeting.TargetingRuleException;
import dev.openfeature.sdk.EvaluationContext;
import io.github.jamsesso.jsonlogic.JsonLogic;
import io.github.jamsesso.jsonlogic.JsonLogicException;
import io.github.jamsesso.jsonlogic.evaluator.JsonLogicExpression;
import java.util.Map;

public class Operator {
    static final String FLAG_KEY = "$flagKey";
    static final String TARGET_KEY = "targetingKey";
    private final JsonLogic jsonLogicHandler = new JsonLogic();

    public Operator() {
        this.jsonLogicHandler.addOperation((JsonLogicExpression)new Fractional());
        this.jsonLogicHandler.addOperation((JsonLogicExpression)new SemVer());
        this.jsonLogicHandler.addOperation((JsonLogicExpression)new StringComp(StringComp.Type.STARTS_WITH));
        this.jsonLogicHandler.addOperation((JsonLogicExpression)new StringComp(StringComp.Type.ENDS_WITH));
    }

    public Object apply(String flagKey, String targetingRule, EvaluationContext ctx) throws TargetingRuleException {
        Map valueMap = ctx.asObjectMap();
        valueMap.put(FLAG_KEY, flagKey);
        try {
            return this.jsonLogicHandler.apply(targetingRule, (Object)valueMap);
        }
        catch (JsonLogicException e) {
            throw new TargetingRuleException("Error evaluating json logic", e);
        }
    }

    static class FlagProperties {
        private final String flagKey;
        private final String targetingKey;

        FlagProperties(Object from) {
            if (from instanceof Map) {
                Map dataMap = (Map)from;
                Object flagKey = dataMap.get(Operator.FLAG_KEY);
                this.flagKey = flagKey instanceof String ? (String)flagKey : null;
                Object targetKey = dataMap.get(Operator.TARGET_KEY);
                this.targetingKey = targetKey instanceof String ? (String)targetKey : null;
            } else {
                this.flagKey = null;
                this.targetingKey = null;
            }
        }

        public String getFlagKey() {
            return this.flagKey;
        }

        public String getTargetingKey() {
            return this.targetingKey;
        }
    }
}

