/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd;

import dev.openfeature.contrib.providers.flagd.FlagdOptions;
import dev.openfeature.contrib.providers.flagd.resolver.Resolver;
import dev.openfeature.contrib.providers.flagd.resolver.grpc.GrpcResolver;
import dev.openfeature.contrib.providers.flagd.resolver.grpc.cache.CacheFactory;
import dev.openfeature.contrib.providers.flagd.resolver.process.InProcessResolver;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.EventProvider;
import dev.openfeature.sdk.FeatureProvider;
import dev.openfeature.sdk.Metadata;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.ProviderEventDetails;
import dev.openfeature.sdk.ProviderState;
import dev.openfeature.sdk.Value;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlagdProvider
extends EventProvider
implements FeatureProvider {
    private static final Logger log = LoggerFactory.getLogger(FlagdProvider.class);
    private static final String FLAGD_PROVIDER = "flagD Provider";
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Resolver flagResolver;
    private ProviderState state = ProviderState.NOT_READY;
    private EvaluationContext evaluationContext;

    public FlagdProvider() {
        this(FlagdOptions.builder().build());
    }

    public FlagdProvider(FlagdOptions options) {
        switch (options.getResolverType()) {
            case IN_PROCESS: {
                this.flagResolver = new InProcessResolver(options, this::setState);
                break;
            }
            case RPC: {
                this.flagResolver = new GrpcResolver(options, CacheFactory.getCache(options), this::getState, this::setState);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Requested unsupported resolver type of %s", new Object[]{options.getResolverType()}));
            }
        }
    }

    public void initialize(EvaluationContext evaluationContext) throws Exception {
        this.evaluationContext = evaluationContext;
        this.flagResolver.init();
    }

    public void shutdown() {
        try {
            this.flagResolver.shutdown();
        }
        catch (Exception e) {
            log.error("Error during shutdown {}", (Object)FLAGD_PROVIDER, (Object)e);
        }
    }

    public ProviderState getState() {
        Lock l = this.lock.readLock();
        try {
            l.lock();
            ProviderState providerState = this.state;
            return providerState;
        }
        finally {
            l.unlock();
        }
    }

    public Metadata getMetadata() {
        return () -> FLAGD_PROVIDER;
    }

    public ProviderEvaluation<Boolean> getBooleanEvaluation(String key, Boolean defaultValue, EvaluationContext ctx) {
        return this.flagResolver.booleanEvaluation(key, defaultValue, this.mergeContext(ctx));
    }

    public ProviderEvaluation<String> getStringEvaluation(String key, String defaultValue, EvaluationContext ctx) {
        return this.flagResolver.stringEvaluation(key, defaultValue, this.mergeContext(ctx));
    }

    public ProviderEvaluation<Double> getDoubleEvaluation(String key, Double defaultValue, EvaluationContext ctx) {
        return this.flagResolver.doubleEvaluation(key, defaultValue, this.mergeContext(ctx));
    }

    public ProviderEvaluation<Integer> getIntegerEvaluation(String key, Integer defaultValue, EvaluationContext ctx) {
        return this.flagResolver.integerEvaluation(key, defaultValue, this.mergeContext(ctx));
    }

    public ProviderEvaluation<Value> getObjectEvaluation(String key, Value defaultValue, EvaluationContext ctx) {
        return this.flagResolver.objectEvaluation(key, defaultValue, this.mergeContext(ctx));
    }

    private EvaluationContext mergeContext(EvaluationContext clientCallCtx) {
        if (this.evaluationContext != null) {
            return this.evaluationContext.merge(clientCallCtx);
        }
        return clientCallCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(ProviderState newState) {
        ProviderState oldState;
        Lock l = this.lock.writeLock();
        try {
            l.lock();
            oldState = this.state;
            this.state = newState;
        }
        finally {
            l.unlock();
        }
        this.handleStateTransition(oldState, newState);
    }

    private void handleStateTransition(ProviderState oldState, ProviderState newState) {
        if (ProviderState.NOT_READY.equals((Object)oldState) && ProviderState.READY.equals((Object)newState)) {
            log.debug("Init completed");
            return;
        }
        if (ProviderState.READY.equals((Object)oldState) && ProviderState.READY.equals((Object)newState)) {
            log.debug("Configuration changed");
            ProviderEventDetails details = ProviderEventDetails.builder().message("configuration changed").build();
            this.emitProviderConfigurationChanged(details);
            return;
        }
        if (ProviderState.READY.equals((Object)oldState) && ProviderState.ERROR.equals((Object)newState)) {
            log.debug("There has been an error");
            ProviderEventDetails details = ProviderEventDetails.builder().message("there has been an error").build();
            this.emitProviderError(details);
            return;
        }
        if (ProviderState.ERROR.equals((Object)oldState) && ProviderState.READY.equals((Object)newState)) {
            log.debug("Recovered from error");
            ProviderEventDetails details = ProviderEventDetails.builder().message("recovered from error").build();
            this.emitProviderReady(details);
            this.emitProviderConfigurationChanged(details);
        }
    }
}

