/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.process;

import dev.openfeature.contrib.providers.flagd.FlagdOptions;
import dev.openfeature.contrib.providers.flagd.resolver.Resolver;
import dev.openfeature.contrib.providers.flagd.resolver.common.Util;
import dev.openfeature.contrib.providers.flagd.resolver.process.model.FeatureFlag;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.FlagStore;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.Storage;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.StorageState;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.Connector;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.file.FileConnector;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.grpc.GrpcStreamConnector;
import dev.openfeature.contrib.providers.flagd.resolver.process.targeting.Operator;
import dev.openfeature.contrib.providers.flagd.resolver.process.targeting.TargetingRuleException;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.ProviderState;
import dev.openfeature.sdk.Reason;
import dev.openfeature.sdk.Value;
import dev.openfeature.sdk.exceptions.FlagNotFoundError;
import dev.openfeature.sdk.exceptions.ParseError;
import dev.openfeature.sdk.exceptions.TypeMismatchError;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InProcessResolver
implements Resolver {
    private static final Logger log = LoggerFactory.getLogger(InProcessResolver.class);
    private final Storage flagStore;
    private final Consumer<ProviderState> stateConsumer;
    private final Operator operator;
    private final long deadline;
    private final AtomicBoolean connected = new AtomicBoolean(false);

    public InProcessResolver(FlagdOptions options, Consumer<ProviderState> stateConsumer) {
        Connector connector = options.isOffline() ? new FileConnector(options.getOfflineFlagSourcePath()) : new GrpcStreamConnector(options);
        this.flagStore = new FlagStore(connector);
        this.deadline = options.getDeadline();
        this.stateConsumer = stateConsumer;
        this.operator = new Operator();
    }

    @Override
    public void init() throws Exception {
        this.flagStore.init();
        Thread stateWatcher = new Thread(() -> {
            try {
                block6: while (true) {
                    StorageState storageState = this.flagStore.getStateQueue().take();
                    switch (storageState) {
                        case OK: {
                            this.stateConsumer.accept(ProviderState.READY);
                            this.connected.set(true);
                            continue block6;
                        }
                        case ERROR: {
                            this.stateConsumer.accept(ProviderState.ERROR);
                            this.connected.set(false);
                            continue block6;
                        }
                    }
                    log.info(String.format("Storage emitted unhandled status: %s", new Object[]{storageState}));
                }
            }
            catch (InterruptedException e) {
                log.warn("Storage state watcher interrupted", (Throwable)e);
                return;
            }
        });
        stateWatcher.setDaemon(true);
        stateWatcher.start();
        Util.busyWaitAndCheck(this.deadline, this.connected);
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.flagStore.shutdown();
        this.connected.set(false);
    }

    @Override
    public ProviderEvaluation<Boolean> booleanEvaluation(String key, Boolean defaultValue, EvaluationContext ctx) {
        return this.resolve(Boolean.class, key, ctx);
    }

    @Override
    public ProviderEvaluation<String> stringEvaluation(String key, String defaultValue, EvaluationContext ctx) {
        return this.resolve(String.class, key, ctx);
    }

    @Override
    public ProviderEvaluation<Double> doubleEvaluation(String key, Double defaultValue, EvaluationContext ctx) {
        return this.resolve(Double.class, key, ctx);
    }

    @Override
    public ProviderEvaluation<Integer> integerEvaluation(String key, Integer defaultValue, EvaluationContext ctx) {
        return this.resolve(Integer.class, key, ctx);
    }

    @Override
    public ProviderEvaluation<Value> objectEvaluation(String key, Value defaultValue, EvaluationContext ctx) {
        ProviderEvaluation<Object> evaluation = this.resolve(Object.class, key, ctx);
        return ProviderEvaluation.builder().value((Object)Value.objectToValue((Object)evaluation.getValue())).variant(evaluation.getVariant()).reason(evaluation.getReason()).errorCode(evaluation.getErrorCode()).errorMessage(evaluation.getErrorMessage()).flagMetadata(evaluation.getFlagMetadata()).build();
    }

    private <T> ProviderEvaluation<T> resolve(Class<T> type, String key, EvaluationContext ctx) {
        String reason;
        Object resolvedVariant;
        FeatureFlag flag = this.flagStore.getFlag(key);
        if (flag == null) {
            throw new FlagNotFoundError("flag: " + key + " not found");
        }
        if ("DISABLED".equals(flag.getState())) {
            throw new FlagNotFoundError("flag: " + key + " is disabled");
        }
        if ("{}".equals(flag.getTargeting())) {
            resolvedVariant = flag.getDefaultVariant();
            reason = Reason.STATIC.toString();
        } else {
            try {
                Object jsonResolved = this.operator.apply(key, flag.getTargeting(), ctx);
                if (jsonResolved == null) {
                    resolvedVariant = flag.getDefaultVariant();
                    reason = Reason.DEFAULT.toString();
                } else {
                    resolvedVariant = jsonResolved;
                    reason = Reason.TARGETING_MATCH.toString();
                }
            }
            catch (TargetingRuleException e) {
                String message = String.format("error evaluating targeting rule for flag %s", key);
                log.debug(message, (Throwable)e);
                throw new ParseError(message);
            }
        }
        Object value = flag.getVariants().get(resolvedVariant);
        if (value == null) {
            String message = String.format("variant %s not found in flag with key %s", resolvedVariant, key);
            log.debug(message);
            throw new TypeMismatchError(message);
        }
        if (value instanceof Integer && type == Double.class) {
            value = ((Integer)value).doubleValue();
        } else if (value instanceof Double && type == Integer.class) {
            value = ((Double)value).intValue();
        }
        if (!type.isAssignableFrom(value.getClass()) || !(resolvedVariant instanceof String)) {
            String message = "returning default variant for flagKey: %s, type not valid";
            log.debug(String.format(message, key));
            throw new TypeMismatchError(message);
        }
        return ProviderEvaluation.builder().value(value).variant((String)resolvedVariant).reason(reason).build();
    }
}

