/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.process.targeting;

import dev.openfeature.contrib.providers.flagd.resolver.process.targeting.Fractional;
import dev.openfeature.contrib.providers.flagd.resolver.process.targeting.SemVer;
import dev.openfeature.contrib.providers.flagd.resolver.process.targeting.StringComp;
import dev.openfeature.contrib.providers.flagd.resolver.process.targeting.TargetingRuleException;
import dev.openfeature.sdk.EvaluationContext;
import io.github.jamsesso.jsonlogic.JsonLogic;
import io.github.jamsesso.jsonlogic.JsonLogicException;
import io.github.jamsesso.jsonlogic.evaluator.JsonLogicExpression;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class Operator {
    static final String FLAGD_PROPS_KEY = "$flagd";
    static final String FLAG_KEY = "flagKey";
    static final String TARGET_KEY = "targetingKey";
    static final String TIME_STAMP = "timestamp";
    private final JsonLogic jsonLogicHandler = new JsonLogic();

    public Operator() {
        this.jsonLogicHandler.addOperation((JsonLogicExpression)new Fractional());
        this.jsonLogicHandler.addOperation((JsonLogicExpression)new SemVer());
        this.jsonLogicHandler.addOperation((JsonLogicExpression)new StringComp(StringComp.Type.STARTS_WITH));
        this.jsonLogicHandler.addOperation((JsonLogicExpression)new StringComp(StringComp.Type.ENDS_WITH));
    }

    public Object apply(String flagKey, String targetingRule, EvaluationContext ctx) throws TargetingRuleException {
        HashMap<String, Object> flagdProperties = new HashMap<String, Object>();
        flagdProperties.put(FLAG_KEY, flagKey);
        long unixTimestamp = Instant.now().getEpochSecond();
        flagdProperties.put(TIME_STAMP, unixTimestamp);
        Map valueMap = ctx.asObjectMap();
        valueMap.put(FLAGD_PROPS_KEY, flagdProperties);
        try {
            return this.jsonLogicHandler.apply(targetingRule, (Object)valueMap);
        }
        catch (JsonLogicException e) {
            throw new TargetingRuleException("Error evaluating json logic", e);
        }
    }

    static class FlagProperties {
        private final Object flagKey;
        private final Object timestamp;
        private final String targetingKey;

        FlagProperties(Object from) {
            if (from instanceof Map) {
                Map dataMap = (Map)from;
                this.flagKey = FlagProperties.extractSubPropertyFromFlagd(dataMap, Operator.FLAG_KEY);
                this.timestamp = FlagProperties.extractSubPropertyFromFlagd(dataMap, Operator.TIME_STAMP);
                Object targetKey = dataMap.get(Operator.TARGET_KEY);
                this.targetingKey = targetKey instanceof String ? (String)targetKey : null;
            } else {
                this.flagKey = null;
                this.timestamp = null;
                this.targetingKey = null;
            }
        }

        private static Object extractSubPropertyFromFlagd(Map<?, ?> dataMap, String propertyName) {
            return Optional.ofNullable(dataMap.get(Operator.FLAGD_PROPS_KEY)).filter(flagdProps -> flagdProps instanceof Map).map(flagdProps -> ((Map)flagdProps).get(propertyName)).orElse(null);
        }

        public Object getFlagKey() {
            return this.flagKey;
        }

        public Object getTimestamp() {
            return this.timestamp;
        }

        public String getTargetingKey() {
            return this.targetingKey;
        }
    }
}

