/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.common;

import dev.openfeature.contrib.providers.flagd.FlagdOptions;
import dev.openfeature.contrib.providers.flagd.resolver.common.FlagdGrpcInterceptor;
import dev.openfeature.contrib.providers.flagd.resolver.common.SslConfigException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.net.SocketAddress;
import javax.net.ssl.SSLException;

public class ChannelBuilder {
    private ChannelBuilder() {
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="certificate path is a user input")
    public static ManagedChannel nettyChannel(FlagdOptions options) {
        if (options.getSocketPath() != null) {
            if (!Epoll.isAvailable()) {
                throw new IllegalStateException("unix socket cannot be used", Epoll.unavailabilityCause());
            }
            return NettyChannelBuilder.forAddress((SocketAddress)new DomainSocketAddress(options.getSocketPath())).eventLoopGroup((EventLoopGroup)new EpollEventLoopGroup()).channelType(EpollDomainSocketChannel.class).usePlaintext().build();
        }
        try {
            NettyChannelBuilder builder = NettyChannelBuilder.forAddress((String)options.getHost(), (int)options.getPort());
            if (options.isTls()) {
                File file;
                SslContextBuilder sslContext = GrpcSslContexts.forClient();
                if (options.getCertPath() != null && (file = new File(options.getCertPath())).exists()) {
                    sslContext.trustManager(file);
                }
                builder.sslContext(sslContext.build());
            } else {
                builder.usePlaintext();
            }
            if (options.getOpenTelemetry() != null) {
                builder.intercept(new ClientInterceptor[]{new FlagdGrpcInterceptor(options.getOpenTelemetry())});
            }
            return builder.build();
        }
        catch (SSLException ssle) {
            SslConfigException sslConfigException = new SslConfigException("Error with SSL configuration.");
            sslConfigException.initCause(ssle);
            throw sslConfigException;
        }
    }
}

