/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.grpc.cache;

import dev.openfeature.contrib.providers.flagd.resolver.grpc.cache.CacheType;
import dev.openfeature.sdk.ProviderEvaluation;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cache {
    private static final Logger log = LoggerFactory.getLogger(Cache.class);
    private Map<String, ProviderEvaluation<?>> store;
    private final Boolean enabled;

    public Cache(String forType, int maxCacheSize) {
        if (CacheType.DISABLED.getValue().equals(forType)) {
            this.enabled = false;
        } else if (CacheType.LRU.getValue().equals(forType)) {
            this.enabled = true;
            this.store = Collections.synchronizedMap(new LRUMap(maxCacheSize));
        } else {
            this.enabled = false;
            log.warn(String.format("Unsupported cache type %s, continuing without cache", forType));
        }
    }

    public void put(String key, ProviderEvaluation<?> value) {
        this.store.put(key, value);
    }

    public ProviderEvaluation<?> get(String key) {
        return this.store.get(key);
    }

    public void remove(String key) {
        this.store.remove(key);
    }

    public void clear() {
        this.store.clear();
    }

    public Boolean getEnabled() {
        return this.enabled;
    }
}

