/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.process.targeting;

import dev.openfeature.contrib.providers.flagd.resolver.process.targeting.Operator;
import io.github.jamsesso.jsonlogic.JsonLogicException;
import io.github.jamsesso.jsonlogic.evaluator.JsonLogicEvaluationException;
import io.github.jamsesso.jsonlogic.evaluator.expressions.PreEvaluatedArgumentsExpression;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.digest.MurmurHash3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Fractional
implements PreEvaluatedArgumentsExpression {
    private static final Logger log = LoggerFactory.getLogger(Fractional.class);

    Fractional() {
    }

    public String key() {
        return "fractional";
    }

    public Object evaluate(List arguments, Object data) throws JsonLogicEvaluationException {
        Object[] distibutions;
        String bucketBy;
        if (arguments.size() < 2) {
            return null;
        }
        Operator.FlagProperties properties = new Operator.FlagProperties(data);
        Object arg1 = arguments.get(0);
        if (arg1 instanceof String) {
            bucketBy = (String)arg1;
            Object[] source = arguments.toArray();
            distibutions = Arrays.copyOfRange(source, 1, source.length);
        } else {
            if (properties.getTargetingKey() == null) {
                log.debug("Missing fallback targeting key");
                return null;
            }
            bucketBy = properties.getFlagKey() + properties.getTargetingKey();
            distibutions = arguments.toArray();
        }
        ArrayList<FractionProperty> propertyList = new ArrayList<FractionProperty>();
        double distribution = 0.0;
        try {
            for (Object dist : distibutions) {
                FractionProperty fractionProperty = new FractionProperty(dist);
                propertyList.add(fractionProperty);
                distribution += (double)fractionProperty.getPercentage();
            }
        }
        catch (JsonLogicException e) {
            log.debug("Error parsing fractional targeting rule", (Throwable)e);
            return null;
        }
        if (distribution != 100.0) {
            log.debug("Fractional properties do not sum to 100");
            return null;
        }
        return Fractional.distributeValue(bucketBy, propertyList);
    }

    private static String distributeValue(String hashKey, List<FractionProperty> propertyList) throws JsonLogicEvaluationException {
        byte[] bytes = hashKey.getBytes(StandardCharsets.UTF_8);
        int mmrHash = MurmurHash3.hash32x86((byte[])bytes, (int)0, (int)bytes.length, (int)0);
        int bucket = (int)((float)Math.abs(mmrHash) * 1.0f / 2.1474836E9f * 100.0f);
        int bucketSum = 0;
        for (FractionProperty p : propertyList) {
            if (bucket >= (bucketSum += p.getPercentage())) continue;
            return p.getVariant();
        }
        throw new JsonLogicEvaluationException("Unable to find a correct bucket");
    }

    private static class FractionProperty {
        private final String variant;
        private final int percentage;

        protected final void finalize() {
        }

        FractionProperty(Object from) throws JsonLogicException {
            if (!(from instanceof List)) {
                throw new JsonLogicException("Property is not an array");
            }
            List array = (List)from;
            if (array.size() != 2) {
                throw new JsonLogicException("Fraction property does not have two elements");
            }
            if (!(array.get(0) instanceof String)) {
                throw new JsonLogicException("First element of the fraction property is not a string variant");
            }
            if (!(array.get(1) instanceof Number)) {
                throw new JsonLogicException("Second element of the fraction property is not a number");
            }
            this.variant = (String)array.get(0);
            this.percentage = ((Number)array.get(1)).intValue();
        }

        public String getVariant() {
            return this.variant;
        }

        public int getPercentage() {
            return this.percentage;
        }
    }
}

