/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd;

import dev.openfeature.contrib.providers.flagd.resolver.grpc.cache.CacheType;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Config {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    static final Resolver DEFAULT_RESOLVER_TYPE = Resolver.RPC;
    static final String DEFAULT_RPC_PORT = "8013";
    static final String DEFAULT_IN_PROCESS_PORT = "8015";
    static final String DEFAULT_TLS = "false";
    static final String DEFAULT_HOST = "localhost";
    static final int DEFAULT_DEADLINE = 500;
    static final int DEFAULT_MAX_CACHE_SIZE = 1000;
    static final long DEFAULT_KEEP_ALIVE = 0L;
    static final String RESOLVER_ENV_VAR = "FLAGD_RESOLVER";
    static final String HOST_ENV_VAR_NAME = "FLAGD_HOST";
    static final String PORT_ENV_VAR_NAME = "FLAGD_PORT";
    static final String TLS_ENV_VAR_NAME = "FLAGD_TLS";
    static final String SOCKET_PATH_ENV_VAR_NAME = "FLAGD_SOCKET_PATH";
    static final String SERVER_CERT_PATH_ENV_VAR_NAME = "FLAGD_SERVER_CERT_PATH";
    static final String CACHE_ENV_VAR_NAME = "FLAGD_CACHE";
    static final String MAX_CACHE_SIZE_ENV_VAR_NAME = "FLAGD_MAX_CACHE_SIZE";
    static final String MAX_EVENT_STREAM_RETRIES_ENV_VAR_NAME = "FLAGD_MAX_EVENT_STREAM_RETRIES";
    static final String BASE_EVENT_STREAM_RETRY_BACKOFF_MS_ENV_VAR_NAME = "FLAGD_RETRY_BACKOFF_MS";
    static final String DEADLINE_MS_ENV_VAR_NAME = "FLAGD_DEADLINE_MS";
    static final String SOURCE_SELECTOR_ENV_VAR_NAME = "FLAGD_SOURCE_SELECTOR";
    static final String OFFLINE_SOURCE_PATH = "FLAGD_OFFLINE_FLAG_SOURCE_PATH";
    static final String KEEP_ALIVE_ENV_VAR_NAME = "FLAGD_KEEP_ALIVE_TIME";
    static final String RESOLVER_RPC = "rpc";
    static final String RESOLVER_IN_PROCESS = "in-process";
    public static final String STATIC_REASON = "STATIC";
    public static final String CACHED_REASON = "CACHED";
    public static final String FLAG_KEY_FIELD = "flag_key";
    public static final String CONTEXT_FIELD = "context";
    public static final String VARIANT_FIELD = "variant";
    public static final String VALUE_FIELD = "value";
    public static final String REASON_FIELD = "reason";
    public static final String METADATA_FIELD = "metadata";
    public static final String LRU_CACHE;
    static final String DEFAULT_CACHE;
    static final int DEFAULT_MAX_EVENT_STREAM_RETRIES = 5;
    static final int BASE_EVENT_STREAM_RETRY_BACKOFF_MS = 1000;

    static String fallBackToEnvOrDefault(String key, String defaultValue) {
        return System.getenv(key) != null ? System.getenv(key) : defaultValue;
    }

    static int fallBackToEnvOrDefault(String key, int defaultValue) {
        try {
            return System.getenv(key) != null ? Integer.parseInt(System.getenv(key)) : defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    static long fallBackToEnvOrDefault(String key, long defaultValue) {
        try {
            return System.getenv(key) != null ? Long.parseLong(System.getenv(key)) : defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    static Resolver fromValueProvider(Function<String, String> provider) {
        String resolverVar = provider.apply(RESOLVER_ENV_VAR);
        if (resolverVar == null) {
            return DEFAULT_RESOLVER_TYPE;
        }
        switch (resolverVar.toLowerCase()) {
            case "in-process": {
                return Resolver.IN_PROCESS;
            }
            case "rpc": {
                return Resolver.RPC;
            }
        }
        log.warn("Unsupported resolver variable: {}", (Object)resolverVar);
        return DEFAULT_RESOLVER_TYPE;
    }

    static {
        DEFAULT_CACHE = LRU_CACHE = CacheType.LRU.getValue();
    }

    public static enum Resolver implements EvaluatorType
    {
        RPC{

            @Override
            public String asString() {
                return Config.RESOLVER_RPC;
            }
        }
        ,
        IN_PROCESS{

            @Override
            public String asString() {
                return Config.RESOLVER_IN_PROCESS;
            }
        };

    }

    @Deprecated
    public static enum Evaluator implements EvaluatorType
    {
        RPC{

            @Override
            public String asString() {
                return Config.RESOLVER_RPC;
            }
        }
        ,
        IN_PROCESS{

            @Override
            public String asString() {
                return Config.RESOLVER_IN_PROCESS;
            }
        };

    }

    static interface EvaluatorType {
        public String asString();
    }
}

