/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd;

import dev.openfeature.contrib.providers.flagd.Config;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.Connector;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import lombok.Generated;

public class FlagdOptions {
    private Config.EvaluatorType resolverType;
    private String host;
    private int port;
    private boolean tls;
    private String certPath;
    private String socketPath;
    private String cacheType;
    private int maxCacheSize;
    private int maxEventStreamRetries;
    private int retryBackoffMs;
    private int deadline;
    private String selector;
    private long keepAlive;
    private String offlineFlagSourcePath;
    private Connector customConnector;
    private OpenTelemetry openTelemetry;

    public static FlagdOptionsBuilder builder() {
        return new FlagdOptionsBuilder(){

            @Override
            public FlagdOptions build() {
                this.prebuild();
                return super.build();
            }
        };
    }

    @Generated
    private static String $default$host() {
        return Config.fallBackToEnvOrDefault("FLAGD_HOST", "localhost");
    }

    @Generated
    private static boolean $default$tls() {
        return Boolean.parseBoolean(Config.fallBackToEnvOrDefault("FLAGD_TLS", "false"));
    }

    @Generated
    private static String $default$certPath() {
        return Config.fallBackToEnvOrDefault("FLAGD_SERVER_CERT_PATH", null);
    }

    @Generated
    private static String $default$socketPath() {
        return Config.fallBackToEnvOrDefault("FLAGD_SOCKET_PATH", null);
    }

    @Generated
    private static String $default$cacheType() {
        return Config.fallBackToEnvOrDefault("FLAGD_CACHE", Config.DEFAULT_CACHE);
    }

    @Generated
    private static int $default$maxCacheSize() {
        return Config.fallBackToEnvOrDefault("FLAGD_MAX_CACHE_SIZE", 1000);
    }

    @Generated
    private static int $default$maxEventStreamRetries() {
        return Config.fallBackToEnvOrDefault("FLAGD_MAX_EVENT_STREAM_RETRIES", 5);
    }

    @Generated
    private static int $default$retryBackoffMs() {
        return Config.fallBackToEnvOrDefault("FLAGD_RETRY_BACKOFF_MS", 1000);
    }

    @Generated
    private static int $default$deadline() {
        return Config.fallBackToEnvOrDefault("FLAGD_DEADLINE_MS", 500);
    }

    @Generated
    private static String $default$selector() {
        return Config.fallBackToEnvOrDefault("FLAGD_SOURCE_SELECTOR", null);
    }

    @Generated
    private static long $default$keepAlive() {
        return Config.fallBackToEnvOrDefault("FLAGD_KEEP_ALIVE_TIME", 0L);
    }

    @Generated
    private static String $default$offlineFlagSourcePath() {
        return Config.fallBackToEnvOrDefault("FLAGD_OFFLINE_FLAG_SOURCE_PATH", null);
    }

    @Generated
    FlagdOptions(Config.EvaluatorType resolverType, String host, int port, boolean tls, String certPath, String socketPath, String cacheType, int maxCacheSize, int maxEventStreamRetries, int retryBackoffMs, int deadline, String selector, long keepAlive, String offlineFlagSourcePath, Connector customConnector, OpenTelemetry openTelemetry) {
        this.resolverType = resolverType;
        this.host = host;
        this.port = port;
        this.tls = tls;
        this.certPath = certPath;
        this.socketPath = socketPath;
        this.cacheType = cacheType;
        this.maxCacheSize = maxCacheSize;
        this.maxEventStreamRetries = maxEventStreamRetries;
        this.retryBackoffMs = retryBackoffMs;
        this.deadline = deadline;
        this.selector = selector;
        this.keepAlive = keepAlive;
        this.offlineFlagSourcePath = offlineFlagSourcePath;
        this.customConnector = customConnector;
        this.openTelemetry = openTelemetry;
    }

    @Generated
    public Config.EvaluatorType getResolverType() {
        return this.resolverType;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public boolean isTls() {
        return this.tls;
    }

    @Generated
    public String getCertPath() {
        return this.certPath;
    }

    @Generated
    public String getSocketPath() {
        return this.socketPath;
    }

    @Generated
    public String getCacheType() {
        return this.cacheType;
    }

    @Generated
    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    @Generated
    public int getMaxEventStreamRetries() {
        return this.maxEventStreamRetries;
    }

    @Generated
    public int getRetryBackoffMs() {
        return this.retryBackoffMs;
    }

    @Generated
    public int getDeadline() {
        return this.deadline;
    }

    @Generated
    public String getSelector() {
        return this.selector;
    }

    @Generated
    public long getKeepAlive() {
        return this.keepAlive;
    }

    @Generated
    public String getOfflineFlagSourcePath() {
        return this.offlineFlagSourcePath;
    }

    @Generated
    public Connector getCustomConnector() {
        return this.customConnector;
    }

    @Generated
    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    public static class FlagdOptionsBuilder {
        @Generated
        private Config.EvaluatorType resolverType;
        @Generated
        private boolean host$set;
        @Generated
        private String host$value;
        @Generated
        private int port;
        @Generated
        private boolean tls$set;
        @Generated
        private boolean tls$value;
        @Generated
        private boolean certPath$set;
        @Generated
        private String certPath$value;
        @Generated
        private boolean socketPath$set;
        @Generated
        private String socketPath$value;
        @Generated
        private boolean cacheType$set;
        @Generated
        private String cacheType$value;
        @Generated
        private boolean maxCacheSize$set;
        @Generated
        private int maxCacheSize$value;
        @Generated
        private boolean maxEventStreamRetries$set;
        @Generated
        private int maxEventStreamRetries$value;
        @Generated
        private boolean retryBackoffMs$set;
        @Generated
        private int retryBackoffMs$value;
        @Generated
        private boolean deadline$set;
        @Generated
        private int deadline$value;
        @Generated
        private boolean selector$set;
        @Generated
        private String selector$value;
        @Generated
        private boolean keepAlive$set;
        @Generated
        private long keepAlive$value;
        @Generated
        private boolean offlineFlagSourcePath$set;
        @Generated
        private String offlineFlagSourcePath$value;
        @Generated
        private Connector customConnector;
        @Generated
        private OpenTelemetry openTelemetry;

        public FlagdOptionsBuilder withGlobalTelemetry(boolean b) {
            if (b) {
                this.openTelemetry = GlobalOpenTelemetry.get();
            }
            return this;
        }

        void prebuild() {
            if (this.resolverType == null) {
                this.resolverType = Config.fromValueProvider(System::getenv);
            }
            if (this.port == 0) {
                this.port = Integer.parseInt(Config.fallBackToEnvOrDefault("FLAGD_PORT", this.determineDefaultPortForResolver()));
            }
        }

        private String determineDefaultPortForResolver() {
            if (this.resolverType.equals(Config.Resolver.RPC)) {
                return "8013";
            }
            return "8015";
        }

        @Generated
        FlagdOptionsBuilder() {
        }

        @Generated
        public FlagdOptionsBuilder resolverType(Config.EvaluatorType resolverType) {
            this.resolverType = resolverType;
            return this;
        }

        @Generated
        public FlagdOptionsBuilder host(String host) {
            this.host$value = host;
            this.host$set = true;
            return this;
        }

        @Generated
        public FlagdOptionsBuilder port(int port) {
            this.port = port;
            return this;
        }

        @Generated
        public FlagdOptionsBuilder tls(boolean tls) {
            this.tls$value = tls;
            this.tls$set = true;
            return this;
        }

        @Generated
        public FlagdOptionsBuilder certPath(String certPath) {
            this.certPath$value = certPath;
            this.certPath$set = true;
            return this;
        }

        @Generated
        public FlagdOptionsBuilder socketPath(String socketPath) {
            this.socketPath$value = socketPath;
            this.socketPath$set = true;
            return this;
        }

        @Generated
        public FlagdOptionsBuilder cacheType(String cacheType) {
            this.cacheType$value = cacheType;
            this.cacheType$set = true;
            return this;
        }

        @Generated
        public FlagdOptionsBuilder maxCacheSize(int maxCacheSize) {
            this.maxCacheSize$value = maxCacheSize;
            this.maxCacheSize$set = true;
            return this;
        }

        @Generated
        public FlagdOptionsBuilder maxEventStreamRetries(int maxEventStreamRetries) {
            this.maxEventStreamRetries$value = maxEventStreamRetries;
            this.maxEventStreamRetries$set = true;
            return this;
        }

        @Generated
        public FlagdOptionsBuilder retryBackoffMs(int retryBackoffMs) {
            this.retryBackoffMs$value = retryBackoffMs;
            this.retryBackoffMs$set = true;
            return this;
        }

        @Generated
        public FlagdOptionsBuilder deadline(int deadline) {
            this.deadline$value = deadline;
            this.deadline$set = true;
            return this;
        }

        @Generated
        public FlagdOptionsBuilder selector(String selector) {
            this.selector$value = selector;
            this.selector$set = true;
            return this;
        }

        @Generated
        public FlagdOptionsBuilder keepAlive(long keepAlive) {
            this.keepAlive$value = keepAlive;
            this.keepAlive$set = true;
            return this;
        }

        @Generated
        public FlagdOptionsBuilder offlineFlagSourcePath(String offlineFlagSourcePath) {
            this.offlineFlagSourcePath$value = offlineFlagSourcePath;
            this.offlineFlagSourcePath$set = true;
            return this;
        }

        @Generated
        public FlagdOptionsBuilder customConnector(Connector customConnector) {
            this.customConnector = customConnector;
            return this;
        }

        @Generated
        public FlagdOptionsBuilder openTelemetry(OpenTelemetry openTelemetry) {
            this.openTelemetry = openTelemetry;
            return this;
        }

        @Generated
        public FlagdOptions build() {
            String host$value = this.host$value;
            if (!this.host$set) {
                host$value = FlagdOptions.$default$host();
            }
            boolean tls$value = this.tls$value;
            if (!this.tls$set) {
                tls$value = FlagdOptions.$default$tls();
            }
            String certPath$value = this.certPath$value;
            if (!this.certPath$set) {
                certPath$value = FlagdOptions.$default$certPath();
            }
            String socketPath$value = this.socketPath$value;
            if (!this.socketPath$set) {
                socketPath$value = FlagdOptions.$default$socketPath();
            }
            String cacheType$value = this.cacheType$value;
            if (!this.cacheType$set) {
                cacheType$value = FlagdOptions.$default$cacheType();
            }
            int maxCacheSize$value = this.maxCacheSize$value;
            if (!this.maxCacheSize$set) {
                maxCacheSize$value = FlagdOptions.$default$maxCacheSize();
            }
            int maxEventStreamRetries$value = this.maxEventStreamRetries$value;
            if (!this.maxEventStreamRetries$set) {
                maxEventStreamRetries$value = FlagdOptions.$default$maxEventStreamRetries();
            }
            int retryBackoffMs$value = this.retryBackoffMs$value;
            if (!this.retryBackoffMs$set) {
                retryBackoffMs$value = FlagdOptions.$default$retryBackoffMs();
            }
            int deadline$value = this.deadline$value;
            if (!this.deadline$set) {
                deadline$value = FlagdOptions.$default$deadline();
            }
            String selector$value = this.selector$value;
            if (!this.selector$set) {
                selector$value = FlagdOptions.$default$selector();
            }
            long keepAlive$value = this.keepAlive$value;
            if (!this.keepAlive$set) {
                keepAlive$value = FlagdOptions.$default$keepAlive();
            }
            String offlineFlagSourcePath$value = this.offlineFlagSourcePath$value;
            if (!this.offlineFlagSourcePath$set) {
                offlineFlagSourcePath$value = FlagdOptions.$default$offlineFlagSourcePath();
            }
            return new FlagdOptions(this.resolverType, host$value, this.port, tls$value, certPath$value, socketPath$value, cacheType$value, maxCacheSize$value, maxEventStreamRetries$value, retryBackoffMs$value, deadline$value, selector$value, keepAlive$value, offlineFlagSourcePath$value, this.customConnector, this.openTelemetry);
        }

        @Generated
        public String toString() {
            return "FlagdOptions.FlagdOptionsBuilder(resolverType=" + this.resolverType + ", host$value=" + this.host$value + ", port=" + this.port + ", tls$value=" + this.tls$value + ", certPath$value=" + this.certPath$value + ", socketPath$value=" + this.socketPath$value + ", cacheType$value=" + this.cacheType$value + ", maxCacheSize$value=" + this.maxCacheSize$value + ", maxEventStreamRetries$value=" + this.maxEventStreamRetries$value + ", retryBackoffMs$value=" + this.retryBackoffMs$value + ", deadline$value=" + this.deadline$value + ", selector$value=" + this.selector$value + ", keepAlive$value=" + this.keepAlive$value + ", offlineFlagSourcePath$value=" + this.offlineFlagSourcePath$value + ", customConnector=" + this.customConnector + ", openTelemetry=" + this.openTelemetry + ")";
        }
    }
}

