/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.file;

import dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.Connector;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.StreamPayload;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.StreamPayloadType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "PATH_TRAVERSAL_IN"}, justification="File connector read feature flag from a file source.")
public class FileConnector
implements Connector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileConnector.class);
    private static final int POLL_INTERVAL_MS = 5000;
    private static final String OFFER_WARN = "Unable to offer file content to queue: queue is full";
    private final String flagSourcePath;
    private final BlockingQueue<StreamPayload> queue = new LinkedBlockingQueue<StreamPayload>(1);
    private boolean shutdown = false;

    public FileConnector(String flagSourcePath) {
        this.flagSourcePath = flagSourcePath;
    }

    @Override
    public void init() throws IOException {
        Thread watcherT = new Thread(() -> {
            block7: {
                try {
                    Path filePath = Paths.get(this.flagSourcePath, new String[0]);
                    String flagData = new String(Files.readAllBytes(filePath), StandardCharsets.UTF_8);
                    if (!this.queue.offer(new StreamPayload(StreamPayloadType.DATA, flagData))) {
                        log.warn(OFFER_WARN);
                    }
                    long lastTS = Files.getLastModifiedTime(filePath, new LinkOption[0]).toMillis();
                    while (!this.shutdown) {
                        long currentTS = Files.getLastModifiedTime(filePath, new LinkOption[0]).toMillis();
                        if (currentTS > lastTS) {
                            lastTS = currentTS;
                            flagData = new String(Files.readAllBytes(filePath), StandardCharsets.UTF_8);
                            if (!this.queue.offer(new StreamPayload(StreamPayloadType.DATA, flagData))) {
                                log.warn(OFFER_WARN);
                            }
                        }
                        Thread.sleep(5000L);
                    }
                    log.info("Shutting down file connector.");
                }
                catch (InterruptedException ex) {
                    log.error("Interrupted while waiting for polling", (Throwable)ex);
                    Thread.currentThread().interrupt();
                }
                catch (Throwable t) {
                    log.error("Error from file connector. File connector will exit", t);
                    if (this.queue.offer(new StreamPayload(StreamPayloadType.ERROR, t.toString()))) break block7;
                    log.warn(OFFER_WARN);
                }
            }
        });
        watcherT.setDaemon(true);
        watcherT.start();
        log.info(String.format("Using feature flag configurations from file %s", this.flagSourcePath));
    }

    @Override
    public BlockingQueue<StreamPayload> getStream() {
        return this.queue;
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.shutdown = true;
    }
}

