/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.grpc;

import dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.grpc.GrpcResponseModel;
import dev.openfeature.flagd.grpc.sync.Sync;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.BlockingQueue;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcStreamHandler
implements StreamObserver<Sync.SyncFlagsResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrpcStreamHandler.class);
    private final BlockingQueue<GrpcResponseModel> blockingQueue;

    GrpcStreamHandler(BlockingQueue<GrpcResponseModel> queue) {
        this.blockingQueue = queue;
    }

    public void onNext(Sync.SyncFlagsResponse syncFlagsResponse) {
        if (!this.blockingQueue.offer(new GrpcResponseModel(syncFlagsResponse))) {
            log.warn("failed to write sync response to queue");
        }
    }

    public void onError(Throwable throwable) {
        if (!this.blockingQueue.offer(new GrpcResponseModel(throwable))) {
            log.warn("failed to write error response to queue");
        }
    }

    public void onCompleted() {
        if (!this.blockingQueue.offer(new GrpcResponseModel(true))) {
            log.warn("failed to write complete status to queue");
        }
    }
}

