/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.process.targeting;

import io.github.jamsesso.jsonlogic.evaluator.JsonLogicEvaluationException;
import io.github.jamsesso.jsonlogic.evaluator.expressions.PreEvaluatedArgumentsExpression;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StringComp
implements PreEvaluatedArgumentsExpression {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StringComp.class);
    private final Type type;

    StringComp(Type type) {
        this.type = type;
    }

    public String key() {
        return this.type.key;
    }

    public Object evaluate(List arguments, Object data) throws JsonLogicEvaluationException {
        if (arguments.size() != 2) {
            log.debug("Incorrect number of arguments for String comparison operator");
            return null;
        }
        Object jsonLogicNode = arguments.get(0);
        if (!(jsonLogicNode instanceof String)) {
            log.debug("Incorrect argument type for first argument");
            return null;
        }
        String arg1 = (String)jsonLogicNode;
        jsonLogicNode = arguments.get(1);
        if (!(jsonLogicNode instanceof String)) {
            log.debug("Incorrect argument type for second argument");
            return null;
        }
        String arg2 = (String)jsonLogicNode;
        switch (this.type) {
            case STARTS_WITH: {
                return arg1.startsWith(arg2);
            }
            case ENDS_WITH: {
                return arg1.endsWith(arg2);
            }
        }
        log.debug(String.format("Unknown string comparison evaluator type %s", new Object[]{this.type}));
        return null;
    }

    static enum Type {
        STARTS_WITH("starts_with"),
        ENDS_WITH("ends_with");

        private final String key;

        private Type(String key) {
            this.key = key;
        }
    }
}

