/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd;

import dev.openfeature.contrib.providers.flagd.FlagdOptions;
import dev.openfeature.contrib.providers.flagd.SyncMetadataHook;
import dev.openfeature.contrib.providers.flagd.resolver.Resolver;
import dev.openfeature.contrib.providers.flagd.resolver.common.ConnectionEvent;
import dev.openfeature.contrib.providers.flagd.resolver.grpc.GrpcResolver;
import dev.openfeature.contrib.providers.flagd.resolver.grpc.cache.Cache;
import dev.openfeature.contrib.providers.flagd.resolver.process.InProcessResolver;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.EventProvider;
import dev.openfeature.sdk.Hook;
import dev.openfeature.sdk.ImmutableContext;
import dev.openfeature.sdk.ImmutableStructure;
import dev.openfeature.sdk.Metadata;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.ProviderEventDetails;
import dev.openfeature.sdk.Structure;
import dev.openfeature.sdk.Value;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlagdProvider
extends EventProvider {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlagdProvider.class);
    private Function<Structure, EvaluationContext> contextEnricher;
    private static final String FLAGD_PROVIDER = "flagd";
    private final Resolver flagResolver;
    private volatile boolean initialized = false;
    private volatile boolean connected = false;
    private volatile Structure syncMetadata = new ImmutableStructure();
    private volatile EvaluationContext enrichedContext = new ImmutableContext();
    private final List<Hook> hooks = new ArrayList<Hook>();

    protected final void finalize() {
    }

    public FlagdProvider() {
        this(FlagdOptions.builder().build());
    }

    public FlagdProvider(FlagdOptions options) {
        switch (options.getResolverType().asString()) {
            case "in-process": {
                this.flagResolver = new InProcessResolver(options, this::isConnected, this::onConnectionEvent);
                break;
            }
            case "rpc": {
                this.flagResolver = new GrpcResolver(options, new Cache(options.getCacheType(), options.getMaxCacheSize()), this::isConnected, this::onConnectionEvent);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Requested unsupported resolver type of %s", options.getResolverType()));
            }
        }
        this.hooks.add(new SyncMetadataHook(this::getEnrichedContext));
        this.contextEnricher = options.getContextEnricher();
    }

    public List<Hook> getProviderHooks() {
        return Collections.unmodifiableList(this.hooks);
    }

    public synchronized void initialize(EvaluationContext evaluationContext) throws Exception {
        if (this.initialized) {
            return;
        }
        this.flagResolver.init();
        this.initialized = true;
    }

    public synchronized void shutdown() {
        if (!this.initialized) {
            return;
        }
        try {
            this.flagResolver.shutdown();
        }
        catch (Exception e) {
            log.error("Error during shutdown {}", (Object)FLAGD_PROVIDER, (Object)e);
        }
        finally {
            this.initialized = false;
        }
    }

    public Metadata getMetadata() {
        return () -> FLAGD_PROVIDER;
    }

    public ProviderEvaluation<Boolean> getBooleanEvaluation(String key, Boolean defaultValue, EvaluationContext ctx) {
        return this.flagResolver.booleanEvaluation(key, defaultValue, ctx);
    }

    public ProviderEvaluation<String> getStringEvaluation(String key, String defaultValue, EvaluationContext ctx) {
        return this.flagResolver.stringEvaluation(key, defaultValue, ctx);
    }

    public ProviderEvaluation<Double> getDoubleEvaluation(String key, Double defaultValue, EvaluationContext ctx) {
        return this.flagResolver.doubleEvaluation(key, defaultValue, ctx);
    }

    public ProviderEvaluation<Integer> getIntegerEvaluation(String key, Integer defaultValue, EvaluationContext ctx) {
        return this.flagResolver.integerEvaluation(key, defaultValue, ctx);
    }

    public ProviderEvaluation<Value> getObjectEvaluation(String key, Value defaultValue, EvaluationContext ctx) {
        return this.flagResolver.objectEvaluation(key, defaultValue, ctx);
    }

    protected Structure getSyncMetadata() {
        return new ImmutableStructure(this.syncMetadata.asMap());
    }

    EvaluationContext getEnrichedContext() {
        return this.enrichedContext;
    }

    private boolean isConnected() {
        return this.connected;
    }

    private void onConnectionEvent(ConnectionEvent connectionEvent) {
        boolean previous = this.connected;
        boolean current = this.connected = connectionEvent.isConnected();
        this.syncMetadata = connectionEvent.getSyncMetadata();
        this.enrichedContext = this.contextEnricher.apply(connectionEvent.getSyncMetadata());
        if (this.initialized && previous && current) {
            log.debug("Configuration changed");
            ProviderEventDetails details = ProviderEventDetails.builder().flagsChanged(connectionEvent.getFlagsChanged()).message("configuration changed").build();
            this.emitProviderConfigurationChanged(details);
            return;
        }
        if (this.initialized && previous && !current) {
            log.debug("There has been an error");
            ProviderEventDetails details = ProviderEventDetails.builder().message("there has been an error").build();
            this.emitProviderError(details);
            return;
        }
        if (this.initialized && !previous && current) {
            log.debug("Recovered from error");
            ProviderEventDetails details = ProviderEventDetails.builder().message("recovered from error").build();
            this.emitProviderReady(details);
            this.emitProviderConfigurationChanged(details);
        }
    }
}

